/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import org.apache.sedona.common.Functions;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.GeometryTransformer;

public class GeometryForce3DMTransformer
extends GeometryTransformer {
    private final double mValue;

    public GeometryForce3DMTransformer(double mValue) {
        this.mValue = mValue;
    }

    protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
        CoordinateXYM[] newCoords = new CoordinateXYM[coords.size()];
        for (int i = 0; i < coords.size(); ++i) {
            Coordinate coordinate = coords.getCoordinate(i);
            newCoords[i] = new CoordinateXYM(coordinate.getX(), coordinate.getY(), this.mValue);
        }
        return this.createCoordinateSequence((Coordinate[])newCoords);
    }

    public static Geometry transform(Geometry geometry, double mValue) {
        if (geometry.getCoordinates().length == 0) {
            return geometry;
        }
        if (Functions.hasM(geometry)) {
            return geometry;
        }
        GeometryForce3DMTransformer transformer = new GeometryForce3DMTransformer(mValue);
        return transformer.transform(geometry);
    }
}

