/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.simplify;

import java.util.ArrayList;
import org.apache.sedona.common.simplify.CoordinatesSimplifier;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class PolygonSimplifier {
    public static Geometry simplify(Polygon geom, boolean preserveCollapsed, double epsilon) {
        LinearRing exteriorRing = geom.getExteriorRing();
        int minPointsExternal = preserveCollapsed ? 4 : 0;
        GeometryFactory geometryFactory = geom.getFactory();
        LinearRing simplifiedExterior = geometryFactory.createLinearRing(CoordinatesSimplifier.simplifyInPlace(exteriorRing.getCoordinates(), epsilon, minPointsExternal));
        if (simplifiedExterior.getNumPoints() < 4) {
            return simplifiedExterior;
        }
        ArrayList<LinearRing> interiorRings = new ArrayList<LinearRing>();
        for (int i = 0; i < geom.getNumInteriorRing(); ++i) {
            LinearRing interiorRing = geom.getInteriorRingN(i);
            Coordinate[] simplifiedInterior = CoordinatesSimplifier.simplifyInPlace(interiorRing.getCoordinates(), epsilon, minPointsExternal);
            if (simplifiedInterior.length < 4) continue;
            interiorRings.add(geometryFactory.createLinearRing(simplifiedInterior));
        }
        return geometryFactory.createPolygon(simplifiedExterior, interiorRings.toArray(new LinearRing[0]));
    }
}

