<!--
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 -->

## GitHub repository

Latest source code: [GitHub repository](https://github.com/apache/sedona/)

Old GeoSpark releases: [GitHub releases](https://github.com/apache/sedona/releases)

Automatically generated binary JARs (per each Master branch commit): [GitHub Action](https://github.com/apache/sedona/actions/workflows/java.yml)

## Verify the integrity

[Public keys](https://downloads.apache.org/sedona/KEYS)

[Instructions](https://www.apache.org/info/verification.html)

## Versions

### 1.7.1

| |                                    Download from ASF                                     |                                         Checksum                                          |                                      Signature                                      |
|:-----------------:|:----------------------------------------------------------------------------------------:|:-----------------------------------------------------------------------------------------:|:-----------------------------------------------------------------------------------:|
|    Source code    | [src](https://www.apache.org/dyn/closer.lua/sedona/1.7.1/apache-sedona-1.7.1-src.tar.gz) | [sha512](https://downloads.apache.org/sedona/1.7.1/apache-sedona-1.7.1-src.tar.gz.sha512) | [asc](https://downloads.apache.org/sedona/1.7.1/apache-sedona-1.7.1-src.tar.gz.asc) |
|       Binary      | [bin](https://www.apache.org/dyn/closer.lua/sedona/1.7.1/apache-sedona-1.7.1-bin.tar.gz) | [sha512](https://downloads.apache.org/sedona/1.7.1/apache-sedona-1.7.1-bin.tar.gz.sha512) | [asc](https://downloads.apache.org/sedona/1.7.1/apache-sedona-1.7.1-bin.tar.gz.asc) |

### 1.7.0

| |                                    Download from ASF                                     |                                         Checksum                                          |                                      Signature                                      |
|:-----------------:|:----------------------------------------------------------------------------------------:|:-----------------------------------------------------------------------------------------:|:-----------------------------------------------------------------------------------:|
|    Source code    | [src](https://www.apache.org/dyn/closer.lua/sedona/1.7.0/apache-sedona-1.7.0-src.tar.gz) | [sha512](https://downloads.apache.org/sedona/1.7.0/apache-sedona-1.7.0-src.tar.gz.sha512) | [asc](https://downloads.apache.org/sedona/1.7.0/apache-sedona-1.7.0-src.tar.gz.asc) |
|       Binary      | [bin](https://www.apache.org/dyn/closer.lua/sedona/1.7.0/apache-sedona-1.7.0-bin.tar.gz) | [sha512](https://downloads.apache.org/sedona/1.7.0/apache-sedona-1.7.0-bin.tar.gz.sha512) | [asc](https://downloads.apache.org/sedona/1.7.0/apache-sedona-1.7.0-bin.tar.gz.asc) |

### 1.6.1

| |                                    Download from ASF                                     |                                         Checksum                                          |                                      Signature                                      |
|:-----------------:|:----------------------------------------------------------------------------------------:|:-----------------------------------------------------------------------------------------:|:-----------------------------------------------------------------------------------:|
|    Source code    | [src](https://www.apache.org/dyn/closer.lua/sedona/1.6.1/apache-sedona-1.6.1-src.tar.gz) | [sha512](https://downloads.apache.org/sedona/1.6.1/apache-sedona-1.6.1-src.tar.gz.sha512) | [asc](https://downloads.apache.org/sedona/1.6.1/apache-sedona-1.6.1-src.tar.gz.asc) |
|       Binary      | [bin](https://www.apache.org/dyn/closer.lua/sedona/1.6.1/apache-sedona-1.6.1-bin.tar.gz) | [sha512](https://downloads.apache.org/sedona/1.6.1/apache-sedona-1.6.1-bin.tar.gz.sha512) | [asc](https://downloads.apache.org/sedona/1.6.1/apache-sedona-1.6.1-bin.tar.gz.asc) |

### Past releases

Past Sedona releases are archived and can be found here: [Apache archive](https://archive.apache.org/dist/sedona/) (on and after 1.2.1-incubating).

## Security

For security issues, please refer to https://www.apache.org/security/
