/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.io.jackson.GeometryAsGeoJSONSerializer;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.impl.BufferedLine;
import org.locationtech.spatial4j.shape.impl.BufferedLineString;
import org.locationtech.spatial4j.shape.impl.GeoCircle;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class ShapeAsGeoJSONSerializer
extends JsonSerializer<Shape> {
    static final String BUFFER = "buffer";
    static final String BUFFER_UNITS = "buffer_units";
    final GeometryAsGeoJSONSerializer forJTS = new GeometryAsGeoJSONSerializer();

    protected void write(JsonGenerator gen, double ... coords) throws IOException {
        gen.writeStartArray();
        for (double coord : coords) {
            if (Double.isNaN(coord)) break;
            gen.writeNumber(coord);
        }
        gen.writeEndArray();
    }

    public static double round(double v) {
        return (double)Math.round(v * 1000000.0) / 1000000.0;
    }

    void writeDistance(JsonGenerator gen, double dist, boolean isGeo, String distProperty, String distUnitsProperty) throws IOException {
        gen.writeFieldName(distProperty);
        if (isGeo) {
            double distKm = DistanceUtils.degrees2Dist(dist, 6371.0087714);
            gen.writeNumber(ShapeAsGeoJSONSerializer.round(distKm));
            gen.writeFieldName("properties");
            gen.writeStartObject();
            gen.writeFieldName(distUnitsProperty);
            gen.writeString("km");
            gen.writeEndObject();
        } else {
            gen.writeNumber(dist);
        }
    }

    public void write(JsonGenerator gen, Shape shape) throws IOException {
        if (shape == null) {
            throw new NullPointerException("Shape can not be null");
        }
        if (shape instanceof Point) {
            Point v = (Point)shape;
            gen.writeStartObject();
            gen.writeFieldName("type");
            gen.writeString("Point");
            gen.writeFieldName("coordinates");
            this.write(gen, v.getX(), v.getY());
            gen.writeEndObject();
            return;
        }
        if (shape instanceof Rectangle) {
            Rectangle v = (Rectangle)shape;
            gen.writeStartObject();
            gen.writeFieldName("type");
            gen.writeString("Polygon");
            gen.writeFieldName("coordinates");
            gen.writeStartArray();
            gen.writeStartArray();
            this.write(gen, v.getMinX(), v.getMinY());
            this.write(gen, v.getMinX(), v.getMaxY());
            this.write(gen, v.getMaxX(), v.getMaxY());
            this.write(gen, v.getMaxX(), v.getMinY());
            this.write(gen, v.getMinX(), v.getMinY());
            gen.writeEndArray();
            gen.writeEndArray();
            gen.writeEndObject();
            return;
        }
        if (shape instanceof BufferedLine) {
            BufferedLine v = (BufferedLine)shape;
            gen.writeStartObject();
            gen.writeFieldName("type");
            gen.writeString("LineString");
            gen.writeFieldName("coordinates");
            gen.writeStartArray();
            this.write(gen, v.getA().getX(), v.getA().getY());
            this.write(gen, v.getB().getX(), v.getB().getY());
            gen.writeEndArray();
            if (v.getBuf() > 0.0) {
                this.writeDistance(gen, v.getBuf(), shape.getContext().isGeo(), BUFFER, BUFFER_UNITS);
            }
            gen.writeEndObject();
            return;
        }
        if (shape instanceof BufferedLineString) {
            BufferedLineString v = (BufferedLineString)shape;
            gen.writeStartObject();
            gen.writeFieldName("type");
            gen.writeString("LineString");
            gen.writeFieldName("coordinates");
            gen.writeStartArray();
            BufferedLine last = null;
            for (BufferedLine seg : v.getSegments()) {
                this.write(gen, seg.getA().getX(), seg.getA().getY());
                last = seg;
            }
            if (last != null) {
                this.write(gen, last.getB().getX(), last.getB().getY());
            }
            gen.writeEndArray();
            if (v.getBuf() > 0.0) {
                this.writeDistance(gen, v.getBuf(), shape.getContext().isGeo(), BUFFER, BUFFER_UNITS);
            }
            gen.writeEndObject();
            return;
        }
        if (shape instanceof Circle) {
            Circle v = (Circle)shape;
            Point center = v.getCenter();
            gen.writeStartObject();
            gen.writeFieldName("type");
            gen.writeString("Circle");
            gen.writeFieldName("coordinates");
            this.write(gen, center.getX(), center.getY());
            this.writeDistance(gen, v.getRadius(), v instanceof GeoCircle, "radius", "radius_units");
            gen.writeEndObject();
            return;
        }
        if (shape instanceof ShapeCollection) {
            ShapeCollection v = (ShapeCollection)shape;
            gen.writeStartObject();
            gen.writeFieldName("type");
            gen.writeString("GeometryCollection");
            gen.writeFieldName("geometries");
            gen.writeStartArray();
            for (int i = 0; i < v.size(); ++i) {
                this.write(gen, (Shape)v.get(i));
            }
            gen.writeEndArray();
            gen.writeEndObject();
            return;
        }
        gen.writeStartObject();
        gen.writeFieldName("type");
        gen.writeString("Unknown");
        gen.writeFieldName("wkt");
        gen.writeString(shape.getContext().getFormats().getWktWriter().toString(shape));
        gen.writeEndObject();
    }

    @Override
    public void serialize(Shape shape, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        if (shape instanceof JtsGeometry) {
            this.forJTS.serialize(((JtsGeometry)shape).getGeom(), gen, serializers);
            return;
        }
        this.write(gen, shape);
    }
}

