/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.joinJudgement;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sedona.core.enums.DistanceMetric;
import org.apache.sedona.core.joinJudgement.JudgementBase;
import org.apache.sedona.core.knnJudgement.EuclideanItemDistance;
import org.apache.sedona.core.knnJudgement.HaversineItemDistance;
import org.apache.sedona.core.knnJudgement.SpheroidDistance;
import org.apache.spark.api.java.function.FlatMapFunction2;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.util.LongAccumulator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.GeometryItemDistance;
import org.locationtech.jts.index.strtree.ItemDistance;
import org.locationtech.jts.index.strtree.STRtree;

public class KnnJoinIndexJudgement<T extends Geometry, U extends Geometry>
extends JudgementBase<T, U>
implements FlatMapFunction2<Iterator<T>, Iterator<SpatialIndex>, Pair<U, T>>,
Serializable {
    private final int k;
    private final DistanceMetric distanceMetric;
    private final boolean includeTies;
    private final Broadcast<STRtree> broadcastedTreeIndex;

    public KnnJoinIndexJudgement(int k, DistanceMetric distanceMetric, boolean includeTies, Broadcast<STRtree> broadcastedTreeIndex, LongAccumulator buildCount, LongAccumulator streamCount, LongAccumulator resultCount, LongAccumulator candidateCount) {
        super(null, buildCount, streamCount, resultCount, candidateCount);
        this.k = k;
        this.distanceMetric = distanceMetric;
        this.includeTies = includeTies;
        this.broadcastedTreeIndex = broadcastedTreeIndex;
    }

    public Iterator<Pair<U, T>> call(Iterator<T> streamShapes, Iterator<SpatialIndex> treeIndexes) throws Exception {
        STRtree strTree;
        if (!treeIndexes.hasNext() || !streamShapes.hasNext()) {
            this.buildCount.add(0L);
            this.streamCount.add(0L);
            this.resultCount.add(0L);
            this.candidateCount.add(0L);
            return Collections.emptyIterator();
        }
        if (this.broadcastedTreeIndex != null) {
            strTree = (STRtree)this.broadcastedTreeIndex.getValue();
        } else {
            SpatialIndex treeIndex = treeIndexes.next();
            if (!(treeIndex instanceof STRtree)) {
                throw new Exception("[KnnJoinIndexJudgement][Call] Only STRtree index supports KNN search.");
            }
            strTree = (STRtree)treeIndex;
        }
        ArrayList<Pair> result = new ArrayList<Pair>();
        while (streamShapes.hasNext()) {
            ItemDistance itemDistance;
            Geometry streamShape = (Geometry)streamShapes.next();
            this.streamCount.add(1L);
            switch (this.distanceMetric) {
                case EUCLIDEAN: {
                    itemDistance = new EuclideanItemDistance();
                    break;
                }
                case HAVERSINE: {
                    itemDistance = new HaversineItemDistance();
                    break;
                }
                case SPHEROID: {
                    itemDistance = new SpheroidDistance();
                    break;
                }
                default: {
                    itemDistance = new GeometryItemDistance();
                }
            }
            Object[] localK = strTree.nearestNeighbour(streamShape.getEnvelopeInternal(), streamShape, itemDistance, this.k);
            if (this.includeTies) {
                localK = this.getUpdatedLocalKWithTies(streamShape, localK, strTree);
            }
            for (Object obj : localK) {
                Geometry candidate = (Geometry)obj;
                Pair pair = Pair.of((Object)streamShape, (Object)candidate);
                result.add(pair);
                this.resultCount.add(1L);
            }
        }
        return result.iterator();
    }

    private Object[] getUpdatedLocalKWithTies(T streamShape, Object[] localK, STRtree strTree) {
        Envelope searchEnvelope = ((Geometry)streamShape).getEnvelopeInternal();
        double maxDistance = 0.0;
        LinkedHashSet<Geometry> uniqueCandidates = new LinkedHashSet<Geometry>();
        for (Object obj : localK) {
            Geometry candidate = (Geometry)obj;
            uniqueCandidates.add(candidate);
            double distance = ((Geometry)streamShape).distance(candidate);
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
        }
        searchEnvelope.expandBy(maxDistance);
        List candidates = strTree.query(searchEnvelope);
        if (!candidates.isEmpty()) {
            ArrayList<Geometry> tiedResults = new ArrayList<Geometry>();
            Collections.addAll(tiedResults, localK);
            for (Geometry candidate : candidates) {
                double distance = ((Geometry)streamShape).distance(candidate);
                if (distance != maxDistance || uniqueCandidates.contains(candidate)) continue;
                tiedResults.add(candidate);
            }
            localK = tiedResults.toArray();
        }
        return localK;
    }
}

