/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.construct;

import java.util.List;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.PolygonalExtracter;
import org.locationtech.jts.index.strtree.STRtree;

class IndexedPointInPolygonsLocator
implements PointOnGeometryLocator {
    private Geometry geom;
    private STRtree index;

    public IndexedPointInPolygonsLocator(Geometry geom) {
        this.geom = geom;
    }

    private void init() {
        if (this.index != null) {
            return;
        }
        List<Geometry> polys = PolygonalExtracter.getPolygonals(this.geom);
        this.index = new STRtree();
        for (int i = 0; i < polys.size(); ++i) {
            Geometry poly = polys.get(i);
            this.index.insert(poly.getEnvelopeInternal(), (Object)new IndexedPointInAreaLocator(poly));
        }
    }

    @Override
    public int locate(Coordinate p) {
        this.init();
        List results = this.index.query(new Envelope(p));
        for (IndexedPointInAreaLocator ptLocater : results) {
            int loc = ptLocater.locate(p);
            if (loc == 2) continue;
            return loc;
        }
        return 2;
    }
}

