/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import javax.annotation.concurrent.Immutable;
import ucar.units.BaseUnit;
import ucar.units.Dimension;
import ucar.units.Factor;
import ucar.units.QuantityDimension;

@Immutable
public final class UnitDimension
extends Dimension {
    public UnitDimension() {
    }

    public UnitDimension(BaseUnit baseUnit) {
        super(new Factor(baseUnit));
    }

    private UnitDimension(Factor[] factors) {
        super(factors);
    }

    public UnitDimension multiplyBy(UnitDimension that) {
        return new UnitDimension(this.mult(that));
    }

    public UnitDimension divideBy(UnitDimension that) {
        return this.multiplyBy(that.raiseTo(-1));
    }

    public UnitDimension raiseTo(int power) {
        return new UnitDimension(this.pow(power));
    }

    public QuantityDimension getQuantityDimension() {
        Factor[] factors = this.getFactors();
        int i = factors.length;
        while (--i >= 0) {
            Factor factor = factors[i];
            factors[i] = new Factor(((BaseUnit)factor.getBase()).getBaseQuantity(), factor.getExponent());
        }
        return new QuantityDimension(factors);
    }
}

