/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.http.HttpHost;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.impl.client.BasicAuthCache;
import ucar.httpservices.HTTPCredentialsProvider;

@ThreadSafe
public class HTTPAuthCache
extends BasicAuthCache {
    List<CredentialsProvider> credsources = new ArrayList<CredentialsProvider>();

    public HTTPAuthCache(SchemePortResolver schemePortResolver) {
        super(schemePortResolver);
    }

    public HTTPAuthCache() {
        this(null);
    }

    @Override
    public synchronized void remove(HttpHost host) {
        super.remove(host);
        for (CredentialsProvider cp : this.credsources) {
            if (cp instanceof HTTPCredentialsProvider) {
                ((HTTPCredentialsProvider)cp).remove(host);
                continue;
            }
            cp.clear();
        }
    }

    public synchronized HTTPAuthCache addProvider(CredentialsProvider cp) {
        if (!this.credsources.contains(cp)) {
            this.credsources.add(cp);
        }
        return this;
    }

    public synchronized HTTPAuthCache removeProvider(CredentialsProvider cp) {
        this.credsources.remove(cp);
        return this;
    }
}

