/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection.sat;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.sat.GEOSTransform;

public class Geostationary
extends ProjectionImpl {
    private static final Logger logger = LoggerFactory.getLogger(Geostationary.class);
    private static final String NAME = "geostationary";
    private boolean scaleGeoCoordinate;
    private double geoCoordinateScaleFactor = Double.MIN_VALUE;
    private GEOSTransform navigation;

    public Geostationary(double subLonDegrees, double perspective_point_height, double semi_minor_axis, double semi_major_axis, double inv_flattening, boolean isSweepX) {
        this(subLonDegrees, perspective_point_height, semi_minor_axis, semi_major_axis, inv_flattening, isSweepX, -1.0);
    }

    public Geostationary(double subLonDegrees, double perspective_point_height, double semi_minor_axis, double semi_major_axis, double inv_flattening, boolean isSweepX, double geoCoordinateScaleFactor) {
        super(NAME, false);
        String sweepAngleAxis = "y";
        if (isSweepX) {
            sweepAngleAxis = "x";
        }
        this.navigation = new GEOSTransform(subLonDegrees, perspective_point_height /= 1000.0, semi_minor_axis /= 1000.0, semi_major_axis /= 1000.0, inv_flattening, sweepAngleAxis);
        this.makePP();
        if (geoCoordinateScaleFactor > 0.0) {
            this.scaleGeoCoordinate = true;
            this.geoCoordinateScaleFactor = geoCoordinateScaleFactor;
        }
        logger.debug("scaleGeoCoordinate {}, geoCoordinateScaleFactor {}", (Object)this.scaleGeoCoordinate, (Object)geoCoordinateScaleFactor);
    }

    public Geostationary() {
        super(NAME, false);
        this.navigation = new GEOSTransform();
        this.makePP();
    }

    public Geostationary(double subLonDegrees) {
        super(NAME, false);
        this.navigation = new GEOSTransform(subLonDegrees, "GOES");
        this.makePP();
    }

    public Geostationary(double subLonDegrees, boolean isSweepX) {
        super(NAME, false);
        String sweepAngleAxis = "y";
        if (isSweepX) {
            sweepAngleAxis = "x";
        }
        String scanGeometry = GEOSTransform.sweepAngleAxisToScanGeom(sweepAngleAxis);
        this.navigation = new GEOSTransform(subLonDegrees, scanGeometry);
        this.makePP();
    }

    public Geostationary(double subLonDegrees, String sweepAngleAxis, double geoCoordinateScaleFactor) {
        super(NAME, false);
        String scanGeometry = GEOSTransform.sweepAngleAxisToScanGeom(sweepAngleAxis);
        this.navigation = new GEOSTransform(subLonDegrees, scanGeometry);
        if (geoCoordinateScaleFactor > 0.0) {
            this.scaleGeoCoordinate = true;
            this.geoCoordinateScaleFactor = geoCoordinateScaleFactor;
        }
        logger.debug("scaleGeoCoordinate {}, geoCoordinateScaleFactor {}", (Object)this.scaleGeoCoordinate, (Object)geoCoordinateScaleFactor);
        this.makePP();
    }

    private void makePP() {
        this.addParameter("grid_mapping_name", NAME);
        this.addParameter("longitude_of_projection_origin", this.navigation.sub_lon_degrees);
        this.addParameter("latitude_of_projection_origin", 0.0);
        this.addParameter("perspective_point_height", this.navigation.sat_height * 1000.0);
        this.addParameter("sweep_angle_axis", GEOSTransform.scanGeomToSweepAngleAxis(this.navigation.scan_geom));
        this.addParameter("semi_major_axis", this.navigation.r_eq * 1000.0);
        this.addParameter("semi_minor_axis", this.navigation.r_pol * 1000.0);
    }

    private boolean isGeoCoordinateScaled() {
        return this.scaleGeoCoordinate && this.geoCoordinateScaleFactor > Double.MIN_VALUE;
    }

    @Override
    public ProjectionImpl constructCopy() {
        String sweepAxisAngle = GEOSTransform.scanGeomToSweepAngleAxis(this.navigation.scan_geom);
        return new Geostationary(this.navigation.sub_lon_degrees, sweepAxisAngle, this.geoCoordinateScaleFactor);
    }

    @Override
    public String paramsToString() {
        return "";
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl destPoint) {
        double[] satCoords = this.navigation.earthToSat(latlon.getLongitude(), latlon.getLatitude());
        double x = satCoords[0];
        double y = satCoords[1];
        if (this.isGeoCoordinateScaled()) {
            x /= this.geoCoordinateScaleFactor;
            y /= this.geoCoordinateScaleFactor;
        }
        destPoint.setLocation(x, y);
        return destPoint;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint ppt, LatLonPointImpl destPoint) {
        double x = ppt.getX();
        double y = ppt.getY();
        if (this.isGeoCoordinateScaled()) {
            x *= this.geoCoordinateScaleFactor;
            y *= this.geoCoordinateScaleFactor;
        }
        double[] lonlat = this.navigation.satToEarth(x, y);
        destPoint.setLongitude(lonlat[0]);
        destPoint.setLatitude(lonlat[1]);
        return destPoint;
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (LatLonPoints.isInfinite(pt1) || LatLonPoints.isInfinite(pt2)) {
            return true;
        }
        double x1 = pt1.getX();
        double x2 = pt2.getX();
        if (this.isGeoCoordinateScaled()) {
            x1 *= this.geoCoordinateScaleFactor;
            x2 *= this.geoCoordinateScaleFactor;
        }
        return x1 * x2 < 0.0 && Math.abs(x1 - x2) > 100.0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Geostationary that = (Geostationary)o;
        if (!this.navigation.equals(that.navigation)) {
            return false;
        }
        return this.geoCoordinateScaleFactor == that.geoCoordinateScaleFactor;
    }

    public int hashCode() {
        return this.navigation.hashCode();
    }

    @Override
    public ProjectionRect latLonToProjBB(LatLonRect rect) {
        return super.latLonToProjBB(rect);
    }
}

