/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.expressions.simplify;

import org.apache.sedona.common.geometryObjects.Circle;
import org.apache.spark.sql.sedona_sql.expressions.simplify.CircleSimplifier$;
import org.apache.spark.sql.sedona_sql.expressions.simplify.GeometryCollectionSimplifier$;
import org.apache.spark.sql.sedona_sql.expressions.simplify.LinestringSimplifier$;
import org.apache.spark.sql.sedona_sql.expressions.simplify.PolygonSimplifier$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.MatchError;

public final class GeometrySimplifier$ {
    public static final GeometrySimplifier$ MODULE$ = new GeometrySimplifier$();

    public Geometry simplify(Geometry geom, boolean preserveCollapsed, double epsilon) {
        Geometry geometry;
        Geometry geometry2 = geom;
        if (geometry2 instanceof Circle) {
            Circle circle = (Circle)geometry2;
            geometry = this.simplifyCircle(circle, preserveCollapsed, epsilon);
        } else if (geometry2 instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry2;
            geometry = this.simplifyGeometryCollection(geometryCollection, preserveCollapsed, epsilon);
        } else if (geometry2 instanceof LineString) {
            LineString lineString = (LineString)geometry2;
            geometry = this.simplifyLineString(lineString, epsilon, preserveCollapsed);
        } else if (geometry2 instanceof Point) {
            Point point = (Point)geometry2;
            geometry = point;
        } else if (geometry2 instanceof Polygon) {
            Polygon polygon = (Polygon)geometry2;
            geometry = this.simplifyPolygon(polygon, preserveCollapsed, epsilon);
        } else if (geometry2 != null) {
            Geometry geometry3;
            geometry = geometry3 = geometry2;
        } else {
            throw new MatchError((Object)geometry2);
        }
        return geometry;
    }

    private Geometry simplifyLineString(LineString geom, double epsilon, boolean preserveCollapsed) {
        return LinestringSimplifier$.MODULE$.simplify(geom, epsilon, preserveCollapsed);
    }

    private Geometry simplifyPolygon(Polygon geom, boolean preserveCollapsed, double epsilon) {
        return PolygonSimplifier$.MODULE$.simplify(geom, preserveCollapsed, epsilon);
    }

    private Geometry simplifyCircle(Circle geom, boolean preserveCollapsed, double epsilon) {
        return CircleSimplifier$.MODULE$.simplify(geom, preserveCollapsed, epsilon);
    }

    private Geometry simplifyGeometryCollection(GeometryCollection geom, boolean preserveCollapsed, double epsilon) {
        return GeometryCollectionSimplifier$.MODULE$.simplify(geom, preserveCollapsed, epsilon);
    }

    private GeometrySimplifier$() {
    }
}

