/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.FrameLocator;
import com.microsoft.playwright.Locator;
import com.microsoft.playwright.impl.FrameImpl;
import com.microsoft.playwright.impl.LocatorImpl;
import com.microsoft.playwright.impl.Utils;

class FrameLocatorImpl
implements FrameLocator {
    private final FrameImpl frame;
    private final String frameSelector;

    FrameLocatorImpl(FrameImpl frame, String selector) {
        this.frame = frame;
        this.frameSelector = selector;
    }

    @Override
    public FrameLocator first() {
        return new FrameLocatorImpl(this.frame, this.frameSelector + " >> nth=0");
    }

    @Override
    public FrameLocatorImpl frameLocator(String selector) {
        return new FrameLocatorImpl(this.frame, this.frameSelector + " >> control=enter-frame >> " + selector);
    }

    @Override
    public FrameLocator last() {
        return new FrameLocatorImpl(this.frame, this.frameSelector + " >> nth=-1");
    }

    @Override
    public Locator locator(String selector, FrameLocator.LocatorOptions options) {
        return new LocatorImpl(this.frame, this.frameSelector + " >> control=enter-frame >> " + selector, Utils.convertType(options, Locator.LocatorOptions.class));
    }

    @Override
    public FrameLocator nth(int index) {
        return new FrameLocatorImpl(this.frame, this.frameSelector + " >> nth=" + index);
    }
}

