/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.launcher.contexts;

import org.apache.royale.test.ant.launcher.OperatingSystem;
import org.apache.royale.test.ant.launcher.commands.TestRunCommand;
import org.apache.royale.test.ant.launcher.commands.playwright.PlaywrightCommand;
import org.apache.royale.test.ant.launcher.commands.process.ProcessCommand;
import org.apache.royale.test.ant.launcher.contexts.DefaultPlaywrightContext;
import org.apache.royale.test.ant.launcher.contexts.DefaultProcessContext;
import org.apache.royale.test.ant.launcher.contexts.ExecutionContext;
import org.apache.royale.test.ant.launcher.contexts.HeadlessContext;
import org.apache.royale.test.ant.launcher.contexts.ProcessExecutionContext;

public class ExecutionContextFactory {
    public static ExecutionContext createContext(OperatingSystem os, boolean headless, int display) {
        boolean trulyHeadless = headless && os == OperatingSystem.LINUX;
        ProcessExecutionContext context = null;
        context = trulyHeadless ? new HeadlessContext(display) : new DefaultProcessContext();
        return context;
    }

    public static ExecutionContext createContext(TestRunCommand command, OperatingSystem os, boolean headless, int display) {
        ExecutionContext context = null;
        if (command instanceof PlaywrightCommand) {
            DefaultPlaywrightContext playwrightContext = new DefaultPlaywrightContext();
            playwrightContext.setCommand((PlaywrightCommand)command);
            context = playwrightContext;
        } else {
            ProcessExecutionContext processContext = null;
            boolean trulyHeadless = headless && os == OperatingSystem.LINUX;
            processContext = trulyHeadless ? new HeadlessContext(display) : new DefaultProcessContext();
            processContext.setCommand((ProcessCommand)command);
            context = processContext;
        }
        return context;
    }
}

