/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.primitives;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;

public final class ByteTypeEncoder
extends AbstractPrimitiveTypeEncoder<Byte> {
    @Override
    public Class<Byte> getTypeClass() {
        return Byte.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, Byte value) {
        buffer.writeByte((byte)81);
        buffer.writeByte(value);
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, byte value) {
        buffer.writeByte((byte)81);
        buffer.writeByte(value);
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte((byte)81);
        for (Object byteVal : values) {
            buffer.writeByte((Byte)byteVal);
        }
    }

    public void writeRawArray(ProtonBuffer buffer, EncoderState state, byte[] values) {
        buffer.writeByte((byte)81);
        for (byte byteVal : values) {
            buffer.writeByte(byteVal);
        }
    }

    public void writeArray(ProtonBuffer buffer, EncoderState state, byte[] values) {
        if (values.length < 254) {
            this.writeAsArray8(buffer, state, values);
        } else {
            this.writeAsArray32(buffer, state, values);
        }
    }

    private void writeAsArray8(ProtonBuffer buffer, EncoderState state, byte[] values) {
        buffer.writeByte((byte)-32);
        int startIndex = buffer.getWriteOffset();
        buffer.writeByte((byte)0);
        buffer.writeByte((byte)values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteOffset();
        long writeSize = endIndex - startIndex - 1;
        buffer.setByte(startIndex, (byte)writeSize);
    }

    private void writeAsArray32(ProtonBuffer buffer, EncoderState state, byte[] values) {
        buffer.writeByte((byte)-16);
        int startIndex = buffer.getWriteOffset();
        buffer.writeInt(0);
        buffer.writeInt(values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteOffset();
        long writeSize = endIndex - startIndex - 4;
        if (writeSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot encode given array, encoded size to large: " + writeSize);
        }
        buffer.setInt(startIndex, (int)writeSize);
    }
}

