/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.sleepycat.je.CacheMode;
import java.io.File;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.berkeleydb.AbstractBDBPreferenceStore;
import org.apache.qpid.server.store.berkeleydb.BDBUtils;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacadeFactory;
import org.apache.qpid.server.store.berkeleydb.StandardEnvironmentConfiguration;
import org.apache.qpid.server.store.berkeleydb.StandardEnvironmentFacade;
import org.apache.qpid.server.store.preferences.PreferenceRecord;
import org.apache.qpid.server.store.preferences.PreferenceStoreUpdater;
import org.apache.qpid.server.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDBPreferenceStore
extends AbstractBDBPreferenceStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(BDBPreferenceStore.class);
    private final String _storePath;
    private final EnvironmentFacadeFactory _environmentFactory;
    private volatile EnvironmentFacade _environmentFacade;

    public BDBPreferenceStore(final ConfiguredObject<?> parent, final String storePath) {
        this._storePath = storePath;
        this._environmentFactory = object -> new StandardEnvironmentFacade(new StandardEnvironmentConfiguration(){

            @Override
            public String getName() {
                return parent.getName();
            }

            @Override
            public String getStorePath() {
                return storePath;
            }

            @Override
            public CacheMode getCacheMode() {
                return BDBUtils.getCacheMode(parent);
            }

            @Override
            public Map<String, String> getParameters() {
                return BDBUtils.getEnvironmentConfigurationParameters(parent);
            }

            @Override
            public <T> T getFacadeParameter(Class<T> paremeterClass, String parameterName, T defaultValue) {
                return BDBUtils.getContextValue(parent, paremeterClass, parameterName, defaultValue);
            }

            @Override
            public <T> T getFacadeParameter(Class<T> paremeterClass, Type type, String parameterName, T defaultValue) {
                return BDBUtils.getContextValue(parent, paremeterClass, type, parameterName, defaultValue);
            }
        });
    }

    @Override
    public Collection<PreferenceRecord> openAndLoad(PreferenceStoreUpdater updater) throws StoreException {
        AbstractBDBPreferenceStore.StoreState storeState = this.getStoreState();
        if (AbstractBDBPreferenceStore.StoreState.OPENED.equals((Object)storeState) || AbstractBDBPreferenceStore.StoreState.OPENING.equals((Object)storeState)) {
            throw new IllegalStateException("PreferenceStore is already opened");
        }
        this._environmentFacade = this._environmentFactory.createEnvironmentFacade(null);
        return super.openAndLoad(updater);
    }

    @Override
    protected void doDelete() {
        if (this._storePath != null) {
            File preferenceStoreFile;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Deleting preference store " + this._storePath);
            }
            if (!FileUtils.delete((File)(preferenceStoreFile = new File(this._storePath)), (boolean)true)) {
                LOGGER.info("Failed to delete the preference store at location " + this._storePath);
            }
        }
    }

    @Override
    protected void doClose() {
        try {
            this._environmentFacade.close();
            this._environmentFacade = null;
        }
        catch (RuntimeException e) {
            throw new StoreException("Exception occurred on preference store close", (Throwable)e);
        }
    }

    @Override
    protected EnvironmentFacade getEnvironmentFacade() {
        return this._environmentFacade;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

