/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

public abstract class PollCondition {
    private final long checkPeriodMs;
    private final long timeoutMs;

    public PollCondition(long checkPeriodMs, long timeoutMs) {
        assert (checkPeriodMs <= timeoutMs);
        this.checkPeriodMs = checkPeriodMs;
        this.timeoutMs = timeoutMs;
    }

    protected abstract boolean condition();

    public boolean await() {
        if (this.condition()) {
            return true;
        }
        long timeLimit = System.currentTimeMillis() + this.timeoutMs;
        do {
            try {
                Thread.sleep(this.checkPeriodMs);
            }
            catch (InterruptedException e) {
                return false;
            }
            if (!this.condition()) continue;
            return true;
        } while (System.currentTimeMillis() < timeLimit);
        return false;
    }
}

