/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.user.connection.limits.config;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.qpid.server.user.connection.limits.config.CombinableLimit;
import org.apache.qpid.server.user.connection.limits.config.ConnectionLimitsImpl;

public interface ConnectionLimits
extends CombinableLimit<ConnectionLimits> {
    public Integer getCountLimit();

    public Map<Duration, Integer> getFrequencyLimits();

    public boolean isUserBlocked();

    @Override
    default public ConnectionLimits then(ConnectionLimits other) {
        if (other != null && this.isEmpty()) {
            return other;
        }
        return this;
    }

    @Override
    default public ConnectionLimits mergeWith(ConnectionLimits second) {
        if (second == null || this.isUserBlocked() || second.isEmpty()) {
            return this;
        }
        if (second.isUserBlocked() || this.isEmpty()) {
            return second;
        }
        return new ConnectionLimitsImpl(this, second);
    }

    public static ConnectionLimits noLimits() {
        return NoLimits.INSTANCE;
    }

    public static final class NoLimits
    implements ConnectionLimits {
        static final NoLimits INSTANCE = new NoLimits();

        private NoLimits() {
        }

        @Override
        public Integer getCountLimit() {
            return null;
        }

        @Override
        public Map<Duration, Integer> getFrequencyLimits() {
            return Collections.emptyMap();
        }

        @Override
        public boolean isUserBlocked() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public ConnectionLimits mergeWith(ConnectionLimits second) {
            return Optional.ofNullable(second).orElse(this);
        }

        @Override
        public ConnectionLimits then(ConnectionLimits other) {
            return Optional.ofNullable(other).orElse(this);
        }
    }
}

