/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.messaging;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.DescribedTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionEncoderImpl;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.codec.AMQPDescribedTypeRegistry;
import org.apache.qpid.server.protocol.v1_0.type.messaging.EncodingRetainingSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.NonEncodingRetainingSection;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;

public abstract class AbstractSection<T, S extends NonEncodingRetainingSection<T>>
implements EncodingRetainingSection<T> {
    private static final AMQPDescribedTypeRegistry TYPE_REGISTRY = AMQPDescribedTypeRegistry.newInstance().registerTransportLayer().registerMessagingLayer().registerTransactionLayer().registerSecurityLayer();
    private T _value;
    private S _section;
    private QpidByteBuffer _encodedForm;
    private long _encodedSize = 0L;

    protected AbstractSection(QpidByteBuffer encodedForm) {
        this._encodedForm = encodedForm.duplicate();
        this._encodedSize = encodedForm.remaining();
    }

    protected AbstractSection(S section) {
        this._value = section.getValue();
        this._section = section;
        this.encodeIfNecessary();
    }

    protected AbstractSection(AbstractSection<T, S> otherAbstractSection) {
        this._value = otherAbstractSection.getValue();
        this._section = otherAbstractSection._section;
        this._encodedForm = otherAbstractSection.getEncodedForm();
        this._encodedSize = this._encodedForm.remaining();
    }

    protected abstract DescribedTypeConstructor<S> createNonEncodingRetainingSectionConstructor();

    @Override
    public synchronized T getValue() {
        if (this._value == null) {
            S section = this.decode(this.createNonEncodingRetainingSectionConstructor());
            this._value = section.getValue();
        }
        return this._value;
    }

    @Override
    public final synchronized QpidByteBuffer getEncodedForm() {
        this.encodeIfNecessary();
        return this._encodedForm.duplicate();
    }

    @Override
    public final synchronized long getEncodedSize() {
        this.encodeIfNecessary();
        return this._encodedSize;
    }

    @Override
    public synchronized void writeTo(QpidByteBuffer dest) {
        this.encodeIfNecessary();
        dest.putCopyOf(this._encodedForm);
    }

    @Override
    public synchronized void clearEncodedForm() {
        if (this._encodedForm != null) {
            this._section = this.decode(this.createNonEncodingRetainingSectionConstructor());
            this._encodedForm.dispose();
            this._encodedForm = null;
            this._encodedSize = 0L;
        }
    }

    @Override
    public final synchronized void reallocate() {
        this._encodedForm = QpidByteBuffer.reallocateIfNecessary((QpidByteBuffer)this._encodedForm);
    }

    @Override
    public final synchronized void dispose() {
        this._section = null;
        this._value = null;
        if (this._encodedForm != null) {
            this._encodedForm.dispose();
            this._encodedForm = null;
            this._encodedSize = 0L;
        }
    }

    public String toString() {
        if (this._value == null) {
            return String.format("<Undecoded %s (%d bytes)>", this.getClass().getSimpleName(), this._encodedSize);
        }
        return this.getValue().toString();
    }

    private void encodeIfNecessary() {
        if (this._encodedForm == null) {
            SectionEncoderImpl sectionEncoder = new SectionEncoderImpl(TYPE_REGISTRY);
            this._encodedForm = sectionEncoder.encodeObject(this._section);
            this._encodedSize = this._encodedForm.remaining();
        }
    }

    private S decode(DescribedTypeConstructor<S> constructor) {
        try (QpidByteBuffer input = this.getEncodedForm();){
            NonEncodingRetainingSection nonEncodingRetainingSection;
            int originalPosition = input.position();
            byte describedByte = input.get();
            if (describedByte != 0) {
                throw new ConnectionScopedRuntimeException("Cannot decode section", (Throwable)new AmqpErrorException(AmqpError.DECODE_ERROR, "Not a described type.", new Object[0]));
            }
            ValueHandler handler = new ValueHandler(TYPE_REGISTRY);
            try {
                Object descriptor = handler.parse(input);
                nonEncodingRetainingSection = (NonEncodingRetainingSection)constructor.construct(descriptor, input, originalPosition, handler).construct(input, handler);
            }
            catch (AmqpErrorException e) {
                throw new ConnectionScopedRuntimeException("Cannot decode section", (Throwable)e);
            }
            return (S)nonEncodingRetainingSection;
        }
    }
}

