/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.store.jdbc;

import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v1_0.store.LinkStore;
import org.apache.qpid.server.protocol.v1_0.store.LinkStoreFactory;
import org.apache.qpid.server.protocol.v1_0.store.jdbc.JDBCLinkStore;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.jdbc.JDBCContainer;

@PluggableService
public class JDBCLinkStoreFactory
implements LinkStoreFactory {
    public static final String TYPE = "JDBC";

    public String getType() {
        return TYPE;
    }

    public LinkStore create(NamedAddressSpace addressSpace) {
        JDBCContainer jdbcContainer = null;
        if (addressSpace instanceof JDBCContainer) {
            jdbcContainer = (JDBCContainer)addressSpace;
        } else if (addressSpace instanceof VirtualHost && ((VirtualHost)addressSpace).getParent() instanceof JDBCContainer) {
            jdbcContainer = (JDBCContainer)((VirtualHost)addressSpace).getParent();
        } else {
            throw new StoreException(String.format("Named address space '%s' is not support by link store of type '%s'", addressSpace.getName(), TYPE));
        }
        return new JDBCLinkStore(jdbcContainer);
    }

    public boolean supports(NamedAddressSpace addressSpace) {
        return addressSpace instanceof JDBCContainer || addressSpace instanceof VirtualHost && ((VirtualHost)addressSpace).getParent() instanceof JDBCContainer;
    }

    public int getPriority() {
        return 100;
    }
}

