/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.intercept;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.mledger.Entry;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public interface ManagedLedgerInterceptor {
    public void beforeAddEntry(AddEntryOperation var1, int var2);

    default public void afterFailedAddEntry(int numberOfMessages) {
    }

    public void onManagedLedgerPropertiesInitialize(Map<String, String> var1);

    public CompletableFuture<Void> onManagedLedgerLastLedgerInitialize(String var1, LastEntryHandle var2);

    public void onUpdateManagedLedgerInfo(Map<String, String> var1);

    default public PayloadProcessorHandle processPayloadBeforeEntryCache(ByteBuf dataReadFromLedger) {
        return null;
    }

    default public PayloadProcessorHandle processPayloadBeforeLedgerWrite(Object ctx, ByteBuf dataToBeStoredInLedger) {
        return null;
    }

    public static interface PayloadProcessorHandle {
        public ByteBuf getProcessedPayload();

        public void release();
    }

    public static interface LastEntryHandle {
        public CompletableFuture<Optional<Entry>> readLastEntryAsync();
    }

    public static interface AddEntryOperation {
        public ByteBuf getData();

        public void setData(ByteBuf var1);

        public Object getCtx();
    }
}

