/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import lombok.Generated;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.mledger.MetadataCompressionConfig;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public class ManagedLedgerFactoryConfig {
    private static final long MB = 0x100000L;
    private long maxCacheSize = 0x8000000L;
    private double cacheEvictionWatermark = 0.9;
    private int numManagedLedgerSchedulerThreads = Runtime.getRuntime().availableProcessors();
    private long cacheEvictionIntervalMs = 10L;
    private long cacheEvictionTimeThresholdMillis = 1000L;
    private long continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis;
    private int cacheEvictionExtendTTLOfEntriesWithRemainingExpectedReadsMaxTimes = 5;
    private boolean cacheEvictionExtendTTLOfRecentlyAccessed = true;
    private boolean copyEntriesInCache = false;
    private long managedLedgerMaxReadsInFlightSize = 0L;
    private long managedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis = 60000L;
    private int managedLedgerMaxReadsInFlightPermitsAcquireQueueSize = 10000;
    private boolean traceTaskExecution = true;
    private int prometheusStatsLatencyRolloverSeconds = 60;
    private int cursorPositionFlushSeconds = 60;
    private int statsPeriodSeconds = 60;
    private String clusterName;
    private String managedLedgerInfoCompressionType = MLDataFormats.CompressionType.NONE.name();
    private long managedLedgerInfoCompressionThresholdInBytes = 0L;
    private String managedCursorInfoCompressionType = MLDataFormats.CompressionType.NONE.name();
    private long managedCursorInfoCompressionThresholdInBytes = 0L;

    public MetadataCompressionConfig getCompressionConfigForManagedLedgerInfo() {
        return new MetadataCompressionConfig(this.managedLedgerInfoCompressionType, this.managedLedgerInfoCompressionThresholdInBytes);
    }

    public MetadataCompressionConfig getCompressionConfigForManagedCursorInfo() {
        return new MetadataCompressionConfig(this.managedCursorInfoCompressionType, this.managedCursorInfoCompressionThresholdInBytes);
    }

    @Generated
    public ManagedLedgerFactoryConfig() {
    }

    @Generated
    public long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @Generated
    public double getCacheEvictionWatermark() {
        return this.cacheEvictionWatermark;
    }

    @Generated
    public int getNumManagedLedgerSchedulerThreads() {
        return this.numManagedLedgerSchedulerThreads;
    }

    @Generated
    public long getCacheEvictionIntervalMs() {
        return this.cacheEvictionIntervalMs;
    }

    @Generated
    public long getCacheEvictionTimeThresholdMillis() {
        return this.cacheEvictionTimeThresholdMillis;
    }

    @Generated
    public long getContinueCachingAddedEntriesAfterLastActiveCursorLeavesMillis() {
        return this.continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis;
    }

    @Generated
    public int getCacheEvictionExtendTTLOfEntriesWithRemainingExpectedReadsMaxTimes() {
        return this.cacheEvictionExtendTTLOfEntriesWithRemainingExpectedReadsMaxTimes;
    }

    @Generated
    public boolean isCacheEvictionExtendTTLOfRecentlyAccessed() {
        return this.cacheEvictionExtendTTLOfRecentlyAccessed;
    }

    @Generated
    public boolean isCopyEntriesInCache() {
        return this.copyEntriesInCache;
    }

    @Generated
    public long getManagedLedgerMaxReadsInFlightSize() {
        return this.managedLedgerMaxReadsInFlightSize;
    }

    @Generated
    public long getManagedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis() {
        return this.managedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis;
    }

    @Generated
    public int getManagedLedgerMaxReadsInFlightPermitsAcquireQueueSize() {
        return this.managedLedgerMaxReadsInFlightPermitsAcquireQueueSize;
    }

    @Generated
    public boolean isTraceTaskExecution() {
        return this.traceTaskExecution;
    }

    @Generated
    public int getPrometheusStatsLatencyRolloverSeconds() {
        return this.prometheusStatsLatencyRolloverSeconds;
    }

    @Generated
    public int getCursorPositionFlushSeconds() {
        return this.cursorPositionFlushSeconds;
    }

    @Generated
    public int getStatsPeriodSeconds() {
        return this.statsPeriodSeconds;
    }

    @Generated
    public String getClusterName() {
        return this.clusterName;
    }

    @Generated
    public String getManagedLedgerInfoCompressionType() {
        return this.managedLedgerInfoCompressionType;
    }

    @Generated
    public long getManagedLedgerInfoCompressionThresholdInBytes() {
        return this.managedLedgerInfoCompressionThresholdInBytes;
    }

    @Generated
    public String getManagedCursorInfoCompressionType() {
        return this.managedCursorInfoCompressionType;
    }

    @Generated
    public long getManagedCursorInfoCompressionThresholdInBytes() {
        return this.managedCursorInfoCompressionThresholdInBytes;
    }

    @Generated
    public void setMaxCacheSize(long maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    @Generated
    public void setCacheEvictionWatermark(double cacheEvictionWatermark) {
        this.cacheEvictionWatermark = cacheEvictionWatermark;
    }

    @Generated
    public void setNumManagedLedgerSchedulerThreads(int numManagedLedgerSchedulerThreads) {
        this.numManagedLedgerSchedulerThreads = numManagedLedgerSchedulerThreads;
    }

    @Generated
    public void setCacheEvictionIntervalMs(long cacheEvictionIntervalMs) {
        this.cacheEvictionIntervalMs = cacheEvictionIntervalMs;
    }

    @Generated
    public void setCacheEvictionTimeThresholdMillis(long cacheEvictionTimeThresholdMillis) {
        this.cacheEvictionTimeThresholdMillis = cacheEvictionTimeThresholdMillis;
    }

    @Generated
    public void setContinueCachingAddedEntriesAfterLastActiveCursorLeavesMillis(long continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis) {
        this.continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis = continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis;
    }

    @Generated
    public void setCacheEvictionExtendTTLOfEntriesWithRemainingExpectedReadsMaxTimes(int cacheEvictionExtendTTLOfEntriesWithRemainingExpectedReadsMaxTimes) {
        this.cacheEvictionExtendTTLOfEntriesWithRemainingExpectedReadsMaxTimes = cacheEvictionExtendTTLOfEntriesWithRemainingExpectedReadsMaxTimes;
    }

    @Generated
    public void setCacheEvictionExtendTTLOfRecentlyAccessed(boolean cacheEvictionExtendTTLOfRecentlyAccessed) {
        this.cacheEvictionExtendTTLOfRecentlyAccessed = cacheEvictionExtendTTLOfRecentlyAccessed;
    }

    @Generated
    public void setCopyEntriesInCache(boolean copyEntriesInCache) {
        this.copyEntriesInCache = copyEntriesInCache;
    }

    @Generated
    public void setManagedLedgerMaxReadsInFlightSize(long managedLedgerMaxReadsInFlightSize) {
        this.managedLedgerMaxReadsInFlightSize = managedLedgerMaxReadsInFlightSize;
    }

    @Generated
    public void setManagedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis(long managedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis) {
        this.managedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis = managedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis;
    }

    @Generated
    public void setManagedLedgerMaxReadsInFlightPermitsAcquireQueueSize(int managedLedgerMaxReadsInFlightPermitsAcquireQueueSize) {
        this.managedLedgerMaxReadsInFlightPermitsAcquireQueueSize = managedLedgerMaxReadsInFlightPermitsAcquireQueueSize;
    }

    @Generated
    public void setTraceTaskExecution(boolean traceTaskExecution) {
        this.traceTaskExecution = traceTaskExecution;
    }

    @Generated
    public void setPrometheusStatsLatencyRolloverSeconds(int prometheusStatsLatencyRolloverSeconds) {
        this.prometheusStatsLatencyRolloverSeconds = prometheusStatsLatencyRolloverSeconds;
    }

    @Generated
    public void setCursorPositionFlushSeconds(int cursorPositionFlushSeconds) {
        this.cursorPositionFlushSeconds = cursorPositionFlushSeconds;
    }

    @Generated
    public void setStatsPeriodSeconds(int statsPeriodSeconds) {
        this.statsPeriodSeconds = statsPeriodSeconds;
    }

    @Generated
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @Generated
    public void setManagedLedgerInfoCompressionType(String managedLedgerInfoCompressionType) {
        this.managedLedgerInfoCompressionType = managedLedgerInfoCompressionType;
    }

    @Generated
    public void setManagedLedgerInfoCompressionThresholdInBytes(long managedLedgerInfoCompressionThresholdInBytes) {
        this.managedLedgerInfoCompressionThresholdInBytes = managedLedgerInfoCompressionThresholdInBytes;
    }

    @Generated
    public void setManagedCursorInfoCompressionType(String managedCursorInfoCompressionType) {
        this.managedCursorInfoCompressionType = managedCursorInfoCompressionType;
    }

    @Generated
    public void setManagedCursorInfoCompressionThresholdInBytes(long managedCursorInfoCompressionThresholdInBytes) {
        this.managedCursorInfoCompressionThresholdInBytes = managedCursorInfoCompressionThresholdInBytes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManagedLedgerFactoryConfig)) {
            return false;
        }
        ManagedLedgerFactoryConfig other = (ManagedLedgerFactoryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxCacheSize() != other.getMaxCacheSize()) {
            return false;
        }
        if (Double.compare(this.getCacheEvictionWatermark(), other.getCacheEvictionWatermark()) != 0) {
            return false;
        }
        if (this.getNumManagedLedgerSchedulerThreads() != other.getNumManagedLedgerSchedulerThreads()) {
            return false;
        }
        if (this.getCacheEvictionIntervalMs() != other.getCacheEvictionIntervalMs()) {
            return false;
        }
        if (this.getCacheEvictionTimeThresholdMillis() != other.getCacheEvictionTimeThresholdMillis()) {
            return false;
        }
        if (this.getContinueCachingAddedEntriesAfterLastActiveCursorLeavesMillis() != other.getContinueCachingAddedEntriesAfterLastActiveCursorLeavesMillis()) {
            return false;
        }
        if (this.getCacheEvictionExtendTTLOfEntriesWithRemainingExpectedReadsMaxTimes() != other.getCacheEvictionExtendTTLOfEntriesWithRemainingExpectedReadsMaxTimes()) {
            return false;
        }
        if (this.isCacheEvictionExtendTTLOfRecentlyAccessed() != other.isCacheEvictionExtendTTLOfRecentlyAccessed()) {
            return false;
        }
        if (this.isCopyEntriesInCache() != other.isCopyEntriesInCache()) {
            return false;
        }
        if (this.getManagedLedgerMaxReadsInFlightSize() != other.getManagedLedgerMaxReadsInFlightSize()) {
            return false;
        }
        if (this.getManagedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis() != other.getManagedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis()) {
            return false;
        }
        if (this.getManagedLedgerMaxReadsInFlightPermitsAcquireQueueSize() != other.getManagedLedgerMaxReadsInFlightPermitsAcquireQueueSize()) {
            return false;
        }
        if (this.isTraceTaskExecution() != other.isTraceTaskExecution()) {
            return false;
        }
        if (this.getPrometheusStatsLatencyRolloverSeconds() != other.getPrometheusStatsLatencyRolloverSeconds()) {
            return false;
        }
        if (this.getCursorPositionFlushSeconds() != other.getCursorPositionFlushSeconds()) {
            return false;
        }
        if (this.getStatsPeriodSeconds() != other.getStatsPeriodSeconds()) {
            return false;
        }
        if (this.getManagedLedgerInfoCompressionThresholdInBytes() != other.getManagedLedgerInfoCompressionThresholdInBytes()) {
            return false;
        }
        if (this.getManagedCursorInfoCompressionThresholdInBytes() != other.getManagedCursorInfoCompressionThresholdInBytes()) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$managedLedgerInfoCompressionType = this.getManagedLedgerInfoCompressionType();
        String other$managedLedgerInfoCompressionType = other.getManagedLedgerInfoCompressionType();
        if (this$managedLedgerInfoCompressionType == null ? other$managedLedgerInfoCompressionType != null : !this$managedLedgerInfoCompressionType.equals(other$managedLedgerInfoCompressionType)) {
            return false;
        }
        String this$managedCursorInfoCompressionType = this.getManagedCursorInfoCompressionType();
        String other$managedCursorInfoCompressionType = other.getManagedCursorInfoCompressionType();
        return !(this$managedCursorInfoCompressionType == null ? other$managedCursorInfoCompressionType != null : !this$managedCursorInfoCompressionType.equals(other$managedCursorInfoCompressionType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ManagedLedgerFactoryConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxCacheSize = this.getMaxCacheSize();
        result = result * 59 + (int)($maxCacheSize >>> 32 ^ $maxCacheSize);
        long $cacheEvictionWatermark = Double.doubleToLongBits(this.getCacheEvictionWatermark());
        result = result * 59 + (int)($cacheEvictionWatermark >>> 32 ^ $cacheEvictionWatermark);
        result = result * 59 + this.getNumManagedLedgerSchedulerThreads();
        long $cacheEvictionIntervalMs = this.getCacheEvictionIntervalMs();
        result = result * 59 + (int)($cacheEvictionIntervalMs >>> 32 ^ $cacheEvictionIntervalMs);
        long $cacheEvictionTimeThresholdMillis = this.getCacheEvictionTimeThresholdMillis();
        result = result * 59 + (int)($cacheEvictionTimeThresholdMillis >>> 32 ^ $cacheEvictionTimeThresholdMillis);
        long $continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis = this.getContinueCachingAddedEntriesAfterLastActiveCursorLeavesMillis();
        result = result * 59 + (int)($continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis >>> 32 ^ $continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis);
        result = result * 59 + this.getCacheEvictionExtendTTLOfEntriesWithRemainingExpectedReadsMaxTimes();
        result = result * 59 + (this.isCacheEvictionExtendTTLOfRecentlyAccessed() ? 79 : 97);
        result = result * 59 + (this.isCopyEntriesInCache() ? 79 : 97);
        long $managedLedgerMaxReadsInFlightSize = this.getManagedLedgerMaxReadsInFlightSize();
        result = result * 59 + (int)($managedLedgerMaxReadsInFlightSize >>> 32 ^ $managedLedgerMaxReadsInFlightSize);
        long $managedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis = this.getManagedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis();
        result = result * 59 + (int)($managedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis >>> 32 ^ $managedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis);
        result = result * 59 + this.getManagedLedgerMaxReadsInFlightPermitsAcquireQueueSize();
        result = result * 59 + (this.isTraceTaskExecution() ? 79 : 97);
        result = result * 59 + this.getPrometheusStatsLatencyRolloverSeconds();
        result = result * 59 + this.getCursorPositionFlushSeconds();
        result = result * 59 + this.getStatsPeriodSeconds();
        long $managedLedgerInfoCompressionThresholdInBytes = this.getManagedLedgerInfoCompressionThresholdInBytes();
        result = result * 59 + (int)($managedLedgerInfoCompressionThresholdInBytes >>> 32 ^ $managedLedgerInfoCompressionThresholdInBytes);
        long $managedCursorInfoCompressionThresholdInBytes = this.getManagedCursorInfoCompressionThresholdInBytes();
        result = result * 59 + (int)($managedCursorInfoCompressionThresholdInBytes >>> 32 ^ $managedCursorInfoCompressionThresholdInBytes);
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $managedLedgerInfoCompressionType = this.getManagedLedgerInfoCompressionType();
        result = result * 59 + ($managedLedgerInfoCompressionType == null ? 43 : $managedLedgerInfoCompressionType.hashCode());
        String $managedCursorInfoCompressionType = this.getManagedCursorInfoCompressionType();
        result = result * 59 + ($managedCursorInfoCompressionType == null ? 43 : $managedCursorInfoCompressionType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ManagedLedgerFactoryConfig(maxCacheSize=" + this.getMaxCacheSize() + ", cacheEvictionWatermark=" + this.getCacheEvictionWatermark() + ", numManagedLedgerSchedulerThreads=" + this.getNumManagedLedgerSchedulerThreads() + ", cacheEvictionIntervalMs=" + this.getCacheEvictionIntervalMs() + ", cacheEvictionTimeThresholdMillis=" + this.getCacheEvictionTimeThresholdMillis() + ", continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis=" + this.getContinueCachingAddedEntriesAfterLastActiveCursorLeavesMillis() + ", cacheEvictionExtendTTLOfEntriesWithRemainingExpectedReadsMaxTimes=" + this.getCacheEvictionExtendTTLOfEntriesWithRemainingExpectedReadsMaxTimes() + ", cacheEvictionExtendTTLOfRecentlyAccessed=" + this.isCacheEvictionExtendTTLOfRecentlyAccessed() + ", copyEntriesInCache=" + this.isCopyEntriesInCache() + ", managedLedgerMaxReadsInFlightSize=" + this.getManagedLedgerMaxReadsInFlightSize() + ", managedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis=" + this.getManagedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis() + ", managedLedgerMaxReadsInFlightPermitsAcquireQueueSize=" + this.getManagedLedgerMaxReadsInFlightPermitsAcquireQueueSize() + ", traceTaskExecution=" + this.isTraceTaskExecution() + ", prometheusStatsLatencyRolloverSeconds=" + this.getPrometheusStatsLatencyRolloverSeconds() + ", cursorPositionFlushSeconds=" + this.getCursorPositionFlushSeconds() + ", statsPeriodSeconds=" + this.getStatsPeriodSeconds() + ", clusterName=" + this.getClusterName() + ", managedLedgerInfoCompressionType=" + this.getManagedLedgerInfoCompressionType() + ", managedLedgerInfoCompressionThresholdInBytes=" + this.getManagedLedgerInfoCompressionThresholdInBytes() + ", managedCursorInfoCompressionType=" + this.getManagedCursorInfoCompressionType() + ", managedCursorInfoCompressionThresholdInBytes=" + this.getManagedCursorInfoCompressionThresholdInBytes() + ")";
    }
}

