/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.apache.pulsar.broker.namespace.NamespaceBundleOwnershipListener;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.TopicPoliciesService;
import org.apache.pulsar.broker.service.TopicPolicyListener;
import org.apache.pulsar.broker.systopic.NamespaceEventsSystemTopicFactory;
import org.apache.pulsar.broker.systopic.SystemTopicClient;
import org.apache.pulsar.broker.systopic.TopicPoliciesSystemTopicClient;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageIdAdv;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.TopicMessageImpl;
import org.apache.pulsar.common.events.ActionType;
import org.apache.pulsar.common.events.EventType;
import org.apache.pulsar.common.events.PulsarEvent;
import org.apache.pulsar.common.events.TopicPoliciesEvent;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.common.stats.CacheMetricsCollector;
import org.apache.pulsar.common.util.FutureUtil;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTopicBasedTopicPoliciesService
implements TopicPoliciesService {
    private final PulsarService pulsarService;
    private final HashSet<String> localCluster;
    private final String clusterName;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ConcurrentInitializer<NamespaceEventsSystemTopicFactory> namespaceEventsSystemTopicFactoryLazyInitializer = new LazyInitializer<NamespaceEventsSystemTopicFactory>(){

        protected NamespaceEventsSystemTopicFactory initialize() {
            try {
                return new NamespaceEventsSystemTopicFactory(SystemTopicBasedTopicPoliciesService.this.pulsarService.getClient());
            }
            catch (PulsarServerException e) {
                log.error("Create namespace event system topic factory error.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    @VisibleForTesting
    final Map<TopicName, TopicPolicies> policiesCache = new ConcurrentHashMap<TopicName, TopicPolicies>();
    final Map<TopicName, TopicPolicies> globalPoliciesCache = new ConcurrentHashMap<TopicName, TopicPolicies>();
    private final Map<NamespaceName, AtomicInteger> ownedBundlesCountPerNamespace = new ConcurrentHashMap<NamespaceName, AtomicInteger>();
    private final Map<NamespaceName, CompletableFuture<SystemTopicClient.Reader<PulsarEvent>>> readerCaches = new ConcurrentHashMap<NamespaceName, CompletableFuture<SystemTopicClient.Reader<PulsarEvent>>>();
    final Map<NamespaceName, CompletableFuture<Void>> policyCacheInitMap = new ConcurrentHashMap<NamespaceName, CompletableFuture<Void>>();
    @VisibleForTesting
    final Map<TopicName, List<TopicPolicyListener>> listeners = new ConcurrentHashMap<TopicName, List<TopicPolicyListener>>();
    private final Map<NamespaceName, TopicPolicyMessageHandlerTracker> topicPolicyMessageHandlerTrackers = new ConcurrentHashMap<NamespaceName, TopicPolicyMessageHandlerTracker>();
    private final AsyncLoadingCache<NamespaceName, SystemTopicClient.Writer<PulsarEvent>> writerCaches;
    private final ConcurrentHashMap<Pair<TopicName, Boolean>, CompletableFuture<Void>> topicPolicyUpdateSequencer = new ConcurrentHashMap();
    private static final Logger log = LoggerFactory.getLogger(SystemTopicBasedTopicPoliciesService.class);

    public SystemTopicBasedTopicPoliciesService(PulsarService pulsarService) {
        this.pulsarService = pulsarService;
        this.clusterName = pulsarService.getConfiguration().getClusterName();
        this.localCluster = Sets.newHashSet((Object[])new String[]{this.clusterName});
        this.writerCaches = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((namespaceName, writer, cause) -> {
            try {
                ((SystemTopicClient.Writer)writer).close();
            }
            catch (Exception e) {
                log.error("[{}] Close writer error.", namespaceName, (Object)e);
            }
        }).recordStats().executor((Executor)pulsarService.getExecutor()).buildAsync((namespaceName, executor) -> {
            if (this.closed.get()) {
                return CompletableFuture.failedFuture(new BrokerServiceException(this.getClass().getName() + " is closed."));
            }
            TopicPoliciesSystemTopicClient systemTopicClient = this.getNamespaceEventsSystemTopicFactory().createTopicPoliciesSystemTopicClient((NamespaceName)namespaceName);
            return systemTopicClient.newWriterAsync();
        });
        CacheMetricsCollector.CAFFEINE.addCache("system-topic-policies-writer-cache", this.writerCaches);
    }

    @Override
    public CompletableFuture<Void> deleteTopicPoliciesAsync(TopicName topicName) {
        return this.deleteTopicPoliciesAsync(topicName, false);
    }

    @Override
    public CompletableFuture<Void> deleteTopicPoliciesAsync(TopicName topicName, boolean keepGlobalPolicies) {
        if (NamespaceService.isHeartbeatNamespace((ServiceUnitId)topicName.getNamespaceObject()) || SystemTopicBasedTopicPoliciesService.isSelf(topicName)) {
            return CompletableFuture.completedFuture(null);
        }
        TopicName changeEvents = NamespaceEventsSystemTopicFactory.getEventsTopicName(topicName.getNamespaceObject());
        CompletionStage changeEventTopicExists = this.pulsarService.getPulsarResources().getTopicResources().persistentTopicExists(changeEvents).thenCompose(nonPartitionedExists -> {
            if (!nonPartitionedExists.booleanValue()) {
                return this.pulsarService.getPulsarResources().getTopicResources().persistentTopicExists(changeEvents.getPartition(0));
            }
            return CompletableFuture.completedFuture(true);
        });
        return ((CompletableFuture)changeEventTopicExists).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                log.info("Skip delete topic-level policies because {} has been removed before", (Object)changeEvents);
                return CompletableFuture.completedFuture(null);
            }
            return this.updateTopicPoliciesAsync(topicName, null, false, ActionType.DELETE, true).thenCompose(__ -> {
                if (keepGlobalPolicies) {
                    return CompletableFuture.completedFuture(null);
                }
                return this.updateTopicPoliciesAsync(topicName, null, true, ActionType.DELETE, true);
            });
        });
    }

    @Override
    public CompletableFuture<Void> updateTopicPoliciesAsync(TopicName topicName, boolean isGlobalPolicy, boolean skipUpdateWhenTopicPolicyDoesntExist, Consumer<TopicPolicies> policyUpdater) {
        if (NamespaceService.isHeartbeatNamespace((ServiceUnitId)topicName.getNamespaceObject())) {
            return CompletableFuture.failedFuture(new BrokerServiceException.NotAllowedException("Not allowed to update topic policy for the heartbeat topic"));
        }
        return this.updateTopicPoliciesAsync(topicName, policyUpdater, isGlobalPolicy, ActionType.UPDATE, skipUpdateWhenTopicPolicyDoesntExist);
    }

    private CompletableFuture<Void> updateTopicPoliciesAsync(TopicName topicName, Consumer<TopicPolicies> policyUpdater, boolean isGlobalPolicy, ActionType actionType, boolean skipUpdateWhenTopicPolicyDoesntExist) {
        if (this.closed.get()) {
            return CompletableFuture.failedFuture(new BrokerServiceException(this.getClass().getName() + " is closed."));
        }
        TopicName partitionedTopicName = TopicName.get((String)topicName.getPartitionedTopicName());
        Pair sequencerKey = Pair.of((Object)partitionedTopicName, (Object)isGlobalPolicy);
        CompletableFuture<Void> operationFuture = new CompletableFuture<Void>();
        this.topicPolicyUpdateSequencer.compute((Pair<TopicName, Boolean>)sequencerKey, (key, existingFuture) -> {
            CompletableFuture chain = existingFuture == null || existingFuture.isDone() ? CompletableFuture.completedFuture(null) : existingFuture;
            return chain.thenCompose(v -> this.pulsarService.getPulsarResources().getNamespaceResources().getPoliciesAsync(topicName.getNamespaceObject()).thenCompose(namespacePolicies -> {
                if (namespacePolicies.isPresent() && ((Policies)namespacePolicies.get()).deleted) {
                    log.debug("[{}] skip sending topic policy event since the namespace is deleted", (Object)topicName);
                    return CompletableFuture.completedFuture(null);
                }
                return ((CompletableFuture)this.getTopicPoliciesAsync(partitionedTopicName, isGlobalPolicy ? TopicPoliciesService.GetType.GLOBAL_ONLY : TopicPoliciesService.GetType.LOCAL_ONLY).thenCompose(currentPolicies -> {
                    TopicPolicies policiesToUpdate;
                    if (currentPolicies.isEmpty() && skipUpdateWhenTopicPolicyDoesntExist) {
                        log.debug("[{}] No existing policies, skipping sending event as requested", (Object)topicName);
                        return CompletableFuture.completedFuture(null);
                    }
                    if (actionType == ActionType.DELETE) {
                        policiesToUpdate = null;
                    } else {
                        policiesToUpdate = currentPolicies.isEmpty() ? SystemTopicBasedTopicPoliciesService.createTopicPolicies(isGlobalPolicy) : ((TopicPolicies)currentPolicies.get()).clone();
                        policyUpdater.accept(policiesToUpdate);
                    }
                    return this.sendTopicPolicyEventInternal(topicName, actionType, policiesToUpdate, isGlobalPolicy);
                })).thenCompose(messageId -> {
                    if (messageId == null) {
                        return CompletableFuture.completedFuture(null);
                    }
                    return this.untilMessageIdHasBeenRead(topicName.getNamespaceObject(), (MessageId)messageId);
                });
            }));
        }).whenComplete((res, ex) -> {
            this.topicPolicyUpdateSequencer.compute((Pair<TopicName, Boolean>)sequencerKey, (key, chainedFuture) -> {
                if (chainedFuture != null && chainedFuture.isDone()) {
                    return null;
                }
                return chainedFuture;
            });
            if (ex != null) {
                operationFuture.completeExceptionally(FutureUtil.unwrapCompletionException((Throwable)ex));
            } else {
                operationFuture.complete((Void)res);
            }
        });
        return operationFuture;
    }

    private CompletableFuture<Void> untilMessageIdHasBeenRead(NamespaceName namespaceObject, MessageId messageId) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getMessageHandlerTracker(namespaceObject).addPendingFuture((MessageIdAdv)messageId, future);
        return future;
    }

    private TopicPolicyMessageHandlerTracker getMessageHandlerTracker(NamespaceName namespaceObject) {
        return this.topicPolicyMessageHandlerTrackers.computeIfAbsent(namespaceObject, ns -> new TopicPolicyMessageHandlerTracker());
    }

    private static TopicPolicies createTopicPolicies(boolean isGlobalPolicy) {
        TopicPolicies topicPolicies = new TopicPolicies();
        topicPolicies.setIsGlobal(Boolean.valueOf(isGlobalPolicy));
        return topicPolicies;
    }

    private CompletableFuture<MessageId> sendTopicPolicyEventInternal(TopicName topicName, ActionType actionType, @Nullable TopicPolicies policies, boolean isGlobalPolicy) {
        return ((CompletableFuture)this.writerCaches.get((Object)topicName.getNamespaceObject()).thenCompose(writer -> {
            PulsarEvent event = this.getPulsarEvent(topicName, actionType, policies, isGlobalPolicy);
            String eventKey = TopicPoliciesService.getEventKey(event, isGlobalPolicy);
            if (actionType == ActionType.DELETE) {
                CompletableFuture<MessageId> future = writer.deleteAsync(eventKey, event);
                future.exceptionally(ex -> {
                    log.error("Failed to delete {} topic policy [{}] error.", new Object[]{isGlobalPolicy ? "global" : "local", topicName, ex});
                    return null;
                });
                return future;
            }
            return writer.writeAsync(eventKey, event);
        })).exceptionally(t -> {
            this.writerCaches.synchronous().invalidate((Object)topicName.getNamespaceObject());
            throw FutureUtil.wrapToCompletionException((Throwable)t);
        });
    }

    private PulsarEvent getPulsarEvent(TopicName topicName, ActionType actionType, @Nullable TopicPolicies policies, boolean isGlobalPolicy) {
        PulsarEvent.PulsarEventBuilder builder = PulsarEvent.builder();
        if (!isGlobalPolicy) {
            builder.replicateTo(this.localCluster);
        }
        return builder.actionType(actionType).eventType(EventType.TOPIC_POLICY).topicPoliciesEvent(TopicPoliciesEvent.builder().domain(topicName.getDomain().toString()).tenant(topicName.getTenant()).namespace(topicName.getNamespaceObject().getLocalName()).topic(TopicName.get((String)topicName.getPartitionedTopicName()).getLocalName()).policies(policies).build()).build();
    }

    private void notifyListener(Message<PulsarEvent> msg) {
        if (msg.getValue() == null) {
            TopicName topicName = TopicName.get((String)TopicPoliciesService.unwrapEventKey(msg.getKey()).getPartitionedTopicName());
            List<TopicPolicyListener> listeners = this.listeners.get(topicName);
            if (listeners != null) {
                for (TopicPolicyListener listener : listeners) {
                    try {
                        listener.onUpdate(null);
                    }
                    catch (Throwable error) {
                        log.error("[{}] call listener error.", (Object)topicName, (Object)error);
                    }
                }
            }
            return;
        }
        if (!EventType.TOPIC_POLICY.equals((Object)((PulsarEvent)msg.getValue()).getEventType())) {
            return;
        }
        TopicPoliciesEvent event = ((PulsarEvent)msg.getValue()).getTopicPoliciesEvent();
        TopicName topicName = TopicName.get((String)event.getDomain(), (String)event.getTenant(), (String)event.getNamespace(), (String)event.getTopic());
        List<TopicPolicyListener> listeners = this.listeners.get(topicName);
        if (listeners != null) {
            TopicPolicies policies = event.getPolicies();
            for (TopicPolicyListener listener : listeners) {
                try {
                    listener.onUpdate(policies);
                }
                catch (Throwable error) {
                    log.error("[{}] call listener error.", (Object)topicName, (Object)error);
                }
            }
        }
    }

    @Override
    public CompletableFuture<Optional<TopicPolicies>> getTopicPoliciesAsync(TopicName topicName, TopicPoliciesService.GetType type) {
        Objects.requireNonNull(topicName);
        NamespaceName namespace = topicName.getNamespaceObject();
        if (NamespaceService.isHeartbeatNamespace((ServiceUnitId)namespace) || SystemTopicBasedTopicPoliciesService.isSelf(topicName)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        LoadManager loadManager = this.pulsarService.getLoadManager().get();
        if (loadManager == null || !loadManager.started() || this.closed.get()) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        CompletableFuture<Boolean> preparedFuture = this.prepareInitPoliciesCacheAsync(topicName.getNamespaceObject());
        return preparedFuture.thenComposeAsync(inserted -> {
            MutableObject policiesFutureHolder = new MutableObject();
            this.policyCacheInitMap.compute(namespace, (arg_0, arg_1) -> this.lambda$getTopicPoliciesAsync$16(inserted, topicName, type, (Mutable)policiesFutureHolder, arg_0, arg_1));
            Pair p = (Pair)policiesFutureHolder.getValue();
            if (!((Boolean)p.getLeft()).booleanValue()) {
                log.info("The future of {} has been removed from cache, retry getTopicPolicies again", (Object)namespace);
                return this.getTopicPoliciesAsync(topicName, type);
            }
            return CompletableFuture.completedFuture((Optional)p.getRight());
        });
    }

    public void addOwnedNamespaceBundleAsync(NamespaceBundle namespaceBundle) {
        NamespaceName namespace = namespaceBundle.getNamespaceObject();
        if (NamespaceService.isHeartbeatNamespace((ServiceUnitId)namespace)) {
            return;
        }
        AtomicInteger bundlesCount = this.ownedBundlesCountPerNamespace.computeIfAbsent(namespace, k -> new AtomicInteger(0));
        int previousCount = bundlesCount.getAndIncrement();
        if (previousCount == 0) {
            this.prepareInitPoliciesCacheAsync(namespace).exceptionally(t -> {
                log.warn("Failed to prepare policies cache for namespace {} due to previously logged error ({}).", (Object)namespace, (Object)t.getMessage());
                return null;
            });
        }
    }

    @VisibleForTesting
    @NonNull CompletableFuture<Boolean> prepareInitPoliciesCacheAsync(@NonNull NamespaceName namespace) {
        Objects.requireNonNull(namespace);
        if (this.closed.get()) {
            return CompletableFuture.completedFuture(false);
        }
        return this.pulsarService.getPulsarResources().getNamespaceResources().getPoliciesAsync(namespace).thenCompose(namespacePolicies -> {
            if (namespacePolicies.isEmpty() || ((Policies)namespacePolicies.get()).deleted) {
                log.info("[{}] skip prepare init policies cache since the namespace is deleted", (Object)namespace);
                return CompletableFuture.completedFuture(false);
            }
            return this.policyCacheInitMap.computeIfAbsent(namespace, k -> {
                CompletableFuture<SystemTopicClient.Reader<PulsarEvent>> readerCompletableFuture = this.createSystemTopicClient(namespace);
                this.readerCaches.put(namespace, readerCompletableFuture);
                CompletionStage initFuture = readerCompletableFuture.thenCompose(reader -> {
                    CompletableFuture<Void> stageFuture = new CompletableFuture<Void>();
                    this.initPolicesCache((SystemTopicClient.Reader<PulsarEvent>)reader, stageFuture);
                    return stageFuture.thenAccept(__ -> this.readMorePoliciesAsync((SystemTopicClient.Reader<PulsarEvent>)reader));
                });
                ((CompletableFuture)initFuture).exceptionallyAsync(ex -> {
                    try {
                        if (this.closed.get()) {
                            return null;
                        }
                        log.error("[{}] Failed to create reader on __change_events topic", (Object)namespace, ex);
                        this.cleanCacheAndCloseReader(namespace, false);
                    }
                    catch (Throwable cleanupEx) {
                        log.error("[{}] Failed to cleanup reader on __change_events topic", (Object)namespace, (Object)cleanupEx);
                    }
                    return null;
                }, (Executor)this.pulsarService.getExecutor());
                return initFuture;
            }).thenApply(__ -> true);
        });
    }

    protected CompletableFuture<SystemTopicClient.Reader<PulsarEvent>> createSystemTopicClient(NamespaceName namespace) {
        if (this.closed.get()) {
            return CompletableFuture.failedFuture(new BrokerServiceException(this.getClass().getName() + " is closed."));
        }
        try {
            this.createSystemTopicFactoryIfNeeded();
        }
        catch (PulsarServerException ex) {
            return FutureUtil.failedFuture((Throwable)ex);
        }
        TopicPoliciesSystemTopicClient systemTopicClient = this.getNamespaceEventsSystemTopicFactory().createTopicPoliciesSystemTopicClient(namespace);
        return systemTopicClient.newReaderAsync();
    }

    private void removeOwnedNamespaceBundleAsync(NamespaceBundle namespaceBundle) {
        NamespaceName namespace = namespaceBundle.getNamespaceObject();
        if (NamespaceService.isHeartbeatNamespace((ServiceUnitId)namespace)) {
            return;
        }
        AtomicInteger bundlesCount = this.ownedBundlesCountPerNamespace.get(namespace);
        if (bundlesCount == null || bundlesCount.decrementAndGet() <= 0) {
            this.cleanCacheAndCloseReader(namespace, true, true);
        }
    }

    @Override
    public void start(final PulsarService pulsarService) {
        pulsarService.getNamespaceService().addNamespaceBundleOwnershipListener(new NamespaceBundleOwnershipListener(){

            @Override
            public void onLoad(NamespaceBundle bundle) {
                pulsarService.getOrderedExecutor().executeOrdered((Object)bundle.getNamespaceObject(), () -> SystemTopicBasedTopicPoliciesService.this.addOwnedNamespaceBundleAsync(bundle));
            }

            @Override
            public void unLoad(NamespaceBundle bundle) {
                pulsarService.getOrderedExecutor().executeOrdered((Object)bundle.getNamespaceObject(), () -> SystemTopicBasedTopicPoliciesService.this.removeOwnedNamespaceBundleAsync(bundle));
            }

            @Override
            public boolean test(NamespaceBundle namespaceBundle) {
                return true;
            }
        });
    }

    private void initPolicesCache(SystemTopicClient.Reader<PulsarEvent> reader, CompletableFuture<Void> future) {
        if (this.closed.get()) {
            future.completeExceptionally(new BrokerServiceException(this.getClass().getName() + " is closed."));
            this.cleanCacheAndCloseReader(reader.getSystemTopic().getTopicName().getNamespaceObject(), false);
            return;
        }
        reader.hasMoreEventsAsync().whenComplete((hasMore, ex) -> {
            if (ex != null) {
                log.error("[{}] Failed to check the move events for the system topic", (Object)reader.getSystemTopic().getTopicName(), ex);
                future.completeExceptionally((Throwable)ex);
                this.cleanCacheAndCloseReader(reader.getSystemTopic().getTopicName().getNamespaceObject(), false);
                return;
            }
            if (hasMore.booleanValue()) {
                ((CompletableFuture)reader.readNextAsync().thenAccept(msg -> {
                    try {
                        this.refreshTopicPoliciesCache((Message<PulsarEvent>)msg);
                    }
                    finally {
                        msg.release();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Loop next event reading for system topic.", (Object)reader.getSystemTopic().getTopicName().getNamespaceObject());
                    }
                    this.initPolicesCache(reader, future);
                })).exceptionally(e -> {
                    log.error("[{}] Failed to read event from the system topic.", (Object)reader.getSystemTopic().getTopicName(), e);
                    future.completeExceptionally((Throwable)e);
                    this.cleanCacheAndCloseReader(reader.getSystemTopic().getTopicName().getNamespaceObject(), false);
                    return null;
                });
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Reach the end of the system topic.", (Object)reader.getSystemTopic().getTopicName());
                }
                this.policiesCache.forEach((topicName, topicPolicies) -> {
                    if (this.listeners.get(topicName) != null) {
                        for (TopicPolicyListener listener : this.listeners.get(topicName)) {
                            try {
                                listener.onUpdate((TopicPolicies)topicPolicies);
                            }
                            catch (Throwable error) {
                                log.error("[{}] call listener error.", topicName, (Object)error);
                            }
                        }
                    }
                });
                future.complete(null);
            }
        });
    }

    private void cleanCacheAndCloseReader(@NonNull NamespaceName namespace, boolean cleanOwnedBundlesCount) {
        this.cleanCacheAndCloseReader(namespace, cleanOwnedBundlesCount, false);
    }

    private void cleanCacheAndCloseReader(@NonNull NamespaceName namespace, boolean cleanOwnedBundlesCount, boolean cleanWriterCache) {
        if (cleanWriterCache) {
            this.writerCaches.synchronous().invalidate((Object)namespace);
        }
        CompletableFuture<SystemTopicClient.Reader<PulsarEvent>> readerFuture = this.readerCaches.remove(namespace);
        TopicPolicyMessageHandlerTracker topicPolicyMessageHandlerTracker = this.topicPolicyMessageHandlerTrackers.remove(namespace);
        if (topicPolicyMessageHandlerTracker != null) {
            topicPolicyMessageHandlerTracker.close();
        }
        if (cleanOwnedBundlesCount) {
            this.ownedBundlesCountPerNamespace.remove(namespace);
        }
        if (readerFuture != null && !readerFuture.isCompletedExceptionally()) {
            ((CompletableFuture)readerFuture.thenCompose(SystemTopicClient.Reader::closeAsync)).exceptionally(ex -> {
                log.warn("[{}] Close change_event reader fail.", (Object)namespace, ex);
                return null;
            });
        }
        this.policyCacheInitMap.compute(namespace, (k, v) -> {
            this.policiesCache.entrySet().removeIf(entry -> Objects.equals(((TopicName)entry.getKey()).getNamespaceObject(), namespace));
            this.globalPoliciesCache.entrySet().removeIf(entry -> Objects.equals(((TopicName)entry.getKey()).getNamespaceObject(), namespace));
            return null;
        });
    }

    private void readMorePoliciesAsync(SystemTopicClient.Reader<PulsarEvent> reader) {
        NamespaceName namespaceObject = reader.getSystemTopic().getTopicName().getNamespaceObject();
        if (this.closed.get()) {
            this.cleanCacheAndCloseReader(namespaceObject, false);
            return;
        }
        ((CompletableFuture)reader.readNextAsync().thenAccept(msg -> {
            try {
                this.refreshTopicPoliciesCache((Message<PulsarEvent>)msg);
                try {
                    this.getMessageHandlerTracker(namespaceObject).handleMessageId((MessageIdAdv)msg.getMessageId());
                }
                finally {
                    this.notifyListener((Message<PulsarEvent>)msg);
                }
            }
            finally {
                msg.release();
            }
        })).whenComplete((__, ex) -> {
            if (ex == null) {
                this.readMorePoliciesAsync(reader);
            } else {
                Throwable cause = FutureUtil.unwrapCompletionException((Throwable)ex);
                if (cause instanceof PulsarClientException.AlreadyClosedException) {
                    log.info("Closing the topic policies reader for {}", (Object)reader.getSystemTopic().getTopicName());
                    this.cleanCacheAndCloseReader(namespaceObject, false);
                } else {
                    log.warn("Read more topic polices exception, read again.", ex);
                    this.readMorePoliciesAsync(reader);
                }
            }
        });
    }

    private void refreshTopicPoliciesCache(Message<PulsarEvent> msg) {
        if (msg.getValue() == null) {
            boolean isGlobalPolicy = TopicPoliciesService.isGlobalPolicy(msg);
            TopicName topicName = TopicName.get((String)TopicPoliciesService.unwrapEventKey(msg.getKey()).getPartitionedTopicName());
            if (isGlobalPolicy) {
                this.globalPoliciesCache.remove(topicName);
            } else {
                this.policiesCache.remove(topicName);
            }
            return;
        }
        if (EventType.TOPIC_POLICY.equals((Object)((PulsarEvent)msg.getValue()).getEventType())) {
            TopicPoliciesEvent event = ((PulsarEvent)msg.getValue()).getTopicPoliciesEvent();
            TopicName topicName = TopicName.get((String)event.getDomain(), (String)event.getTenant(), (String)event.getNamespace(), (String)event.getTopic());
            switch (((PulsarEvent)msg.getValue()).getActionType()) {
                case INSERT: {
                    TopicPolicies old;
                    TopicPolicies topicPolicies = old = event.getPolicies().isGlobalPolicies() ? this.globalPoliciesCache.putIfAbsent(topicName, event.getPolicies()) : this.policiesCache.putIfAbsent(topicName, event.getPolicies());
                    if (old == null) break;
                    log.warn("Policy insert failed, the topic: {} policy already exist", (Object)topicName);
                    break;
                }
                case UPDATE: {
                    if (event.getPolicies().isGlobalPolicies()) {
                        this.globalPoliciesCache.put(topicName, event.getPolicies());
                        break;
                    }
                    this.policiesCache.put(topicName, event.getPolicies());
                    break;
                }
                case DELETE: {
                    this.policiesCache.remove(topicName);
                    this.sendTopicPolicyEventInternal(topicName, ActionType.DELETE, null, event.getPolicies().isGlobalPolicies()).whenComplete((__, ex) -> {
                        if (ex != null) {
                            log.error("Failed to send delete topic policy event for {}", (Object)topicName, ex);
                        }
                    });
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    log.warn("Unknown event action type: {}", (Object)((PulsarEvent)msg.getValue()).getActionType());
                }
            }
        }
    }

    private boolean hasReplicateTo(Message<?> message) {
        if (message instanceof MessageImpl) {
            return ((MessageImpl)message).hasReplicateTo() ? (((MessageImpl)message).getReplicateTo().size() == 1 ? !((MessageImpl)message).getReplicateTo().contains(this.clusterName) : true) : false;
        }
        if (message instanceof TopicMessageImpl) {
            return this.hasReplicateTo(((TopicMessageImpl)message).getMessage());
        }
        return false;
    }

    private void createSystemTopicFactoryIfNeeded() throws PulsarServerException {
        try {
            this.getNamespaceEventsSystemTopicFactory();
        }
        catch (Exception e) {
            throw new PulsarServerException((Throwable)e);
        }
    }

    @VisibleForTesting
    NamespaceEventsSystemTopicFactory getNamespaceEventsSystemTopicFactory() {
        try {
            return (NamespaceEventsSystemTopicFactory)this.namespaceEventsSystemTopicFactoryLazyInitializer.get();
        }
        catch (Exception e) {
            log.error("Create namespace event system topic factory error.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    long getPoliciesCacheSize() {
        return this.policiesCache.size();
    }

    @VisibleForTesting
    boolean checkReaderIsCached(NamespaceName namespaceName) {
        return this.readerCaches.get(namespaceName) != null;
    }

    @VisibleForTesting
    public CompletableFuture<Void> getPoliciesCacheInit(NamespaceName namespaceName) {
        return this.policyCacheInitMap.get(namespaceName);
    }

    @Override
    public boolean registerListener(TopicName topicName, TopicPolicyListener listener) {
        this.listeners.compute(topicName, (k, topicListeners) -> {
            if (topicListeners == null) {
                topicListeners = new CopyOnWriteArrayList<TopicPolicyListener>();
            }
            topicListeners.add(listener);
            return topicListeners;
        });
        return true;
    }

    @Override
    public void unregisterListener(TopicName topicName, TopicPolicyListener listener) {
        this.listeners.compute(topicName, (k, topicListeners) -> {
            if (topicListeners != null) {
                topicListeners.remove(listener);
                if (topicListeners.isEmpty()) {
                    topicListeners = null;
                }
            }
            return topicListeners;
        });
    }

    @VisibleForTesting
    protected Map<TopicName, TopicPolicies> getPoliciesCache() {
        return this.policiesCache;
    }

    @VisibleForTesting
    protected Map<TopicName, List<TopicPolicyListener>> getListeners() {
        return this.listeners;
    }

    @VisibleForTesting
    protected AsyncLoadingCache<NamespaceName, SystemTopicClient.Writer<PulsarEvent>> getWriterCaches() {
        return this.writerCaches;
    }

    @Override
    public void close() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            this.writerCaches.synchronous().invalidateAll();
            this.readerCaches.values().forEach(future -> {
                try {
                    SystemTopicClient.Reader reader = future.getNow(null);
                    if (reader != null) {
                        reader.close();
                        log.info("Closed the reader for topic policies");
                    } else {
                        ((CompletableFuture)future.thenAccept(SystemTopicClient.Reader::closeAsync)).whenComplete((__, e) -> {
                            if (e == null) {
                                log.info("Closed the reader for topic policies");
                            } else {
                                log.error("Failed to close the reader for topic policies", e);
                            }
                        });
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            this.readerCaches.clear();
        }
    }

    private static boolean isSelf(TopicName topicName) {
        String localName = topicName.getLocalName();
        if (!topicName.isPartitioned()) {
            return localName.equals("__change_events");
        }
        int index = localName.lastIndexOf("-partition-");
        return localName.substring(0, index).equals("__change_events");
    }

    @VisibleForTesting
    public int getTopicPolicyUpdateSequencerSize() {
        return this.topicPolicyUpdateSequencer.size();
    }

    private /* synthetic */ CompletableFuture lambda$getTopicPoliciesAsync$16(Boolean inserted, TopicName topicName, TopicPoliciesService.GetType type, Mutable policiesFutureHolder, NamespaceName ___, CompletableFuture existingFuture) {
        if (!inserted.booleanValue() || existingFuture != null) {
            TopicName partitionedTopicName = TopicName.get((String)topicName.getPartitionedTopicName());
            Optional<TopicPolicies> policies = Optional.ofNullable(switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case TopicPoliciesService.GetType.GLOBAL_ONLY -> this.globalPoliciesCache.get(partitionedTopicName);
                case TopicPoliciesService.GetType.LOCAL_ONLY -> this.policiesCache.get(partitionedTopicName);
            });
            policiesFutureHolder.setValue((Object)Pair.of((Object)true, policies));
        } else {
            policiesFutureHolder.setValue((Object)Pair.of((Object)false, null));
        }
        return existingFuture;
    }

    private static class TopicPolicyMessageHandlerTracker
    implements AutoCloseable {
        private final List<MessageIdAdv> lastHandledMessageIds = new ArrayList<MessageIdAdv>();
        private final List<PriorityQueue<PendingMessageFuture>> pendingFutures = new ArrayList<PriorityQueue<PendingMessageFuture>>();
        private boolean closed = false;

        private TopicPolicyMessageHandlerTracker() {
        }

        public synchronized void handleMessageId(MessageIdAdv messageId) {
            if (this.closed) {
                return;
            }
            int partitionIndex = messageId.getPartitionIndex();
            if (partitionIndex < 0) {
                partitionIndex = 0;
            }
            while (this.lastHandledMessageIds.size() <= partitionIndex) {
                this.lastHandledMessageIds.add(null);
            }
            this.lastHandledMessageIds.set(partitionIndex, messageId);
            if (this.pendingFutures.size() > partitionIndex) {
                PriorityQueue<PendingMessageFuture> pq = this.pendingFutures.get(partitionIndex);
                while (!pq.isEmpty() && pq.peek().messageId.compareTo((Object)messageId) <= 0) {
                    PendingMessageFuture pendingFuture = pq.poll();
                    this.completeFuture(pendingFuture.messageId(), pendingFuture.future());
                }
            }
        }

        public synchronized void addPendingFuture(MessageIdAdv messageId, CompletableFuture<Void> future) {
            MessageIdAdv lastHandledMessageId;
            if (this.closed) {
                this.completeFuture((MessageId)messageId, future);
                return;
            }
            int partitionIndex = messageId.getPartitionIndex();
            if (partitionIndex < 0) {
                partitionIndex = 0;
            }
            while (this.pendingFutures.size() <= partitionIndex) {
                this.pendingFutures.add(new PriorityQueue());
            }
            MessageIdAdv messageIdAdv = lastHandledMessageId = this.lastHandledMessageIds.size() > partitionIndex ? this.lastHandledMessageIds.get(partitionIndex) : null;
            if (lastHandledMessageId != null && lastHandledMessageId.compareTo((MessageId)messageId) >= 0) {
                this.completeFuture((MessageId)messageId, future);
                return;
            }
            this.pendingFutures.get(partitionIndex).add(new PendingMessageFuture((MessageId)messageId, future));
        }

        @Override
        public synchronized void close() {
            if (!this.closed) {
                this.closed = true;
                for (PriorityQueue<PendingMessageFuture> pq : this.pendingFutures) {
                    while (!pq.isEmpty()) {
                        PendingMessageFuture pendingFuture = pq.poll();
                        this.completeFuture(pendingFuture.messageId(), pendingFuture.future());
                    }
                }
                this.pendingFutures.clear();
                this.lastHandledMessageIds.clear();
            }
        }

        private void completeFuture(MessageId messageId, CompletableFuture<Void> future) {
            try {
                future.complete(null);
            }
            catch (Exception ex) {
                log.error("Failed to complete pending future for message id {}.", (Object)messageId, (Object)ex);
            }
        }
    }

    private record PendingMessageFuture(MessageId messageId, CompletableFuture<Void> future) implements Comparable<PendingMessageFuture>
    {
        @Override
        public int compareTo(PendingMessageFuture o) {
            return this.messageId.compareTo((Object)o.messageId);
        }
    }
}

