/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import io.netty.util.concurrent.FastThreadLocal;
import lombok.Generated;

public class SendMessageInfo {
    private int totalMessages;
    private long totalBytes;
    private int totalChunkedMessages;
    private static final FastThreadLocal<SendMessageInfo> THREAD_LOCAL = new FastThreadLocal<SendMessageInfo>(){

        protected SendMessageInfo initialValue() throws Exception {
            return new SendMessageInfo();
        }
    };

    private SendMessageInfo() {
    }

    public static SendMessageInfo getThreadLocal() {
        SendMessageInfo smi = (SendMessageInfo)THREAD_LOCAL.get();
        smi.totalMessages = 0;
        smi.totalBytes = 0L;
        smi.totalChunkedMessages = 0;
        return smi;
    }

    @Generated
    public int getTotalMessages() {
        return this.totalMessages;
    }

    @Generated
    public long getTotalBytes() {
        return this.totalBytes;
    }

    @Generated
    public int getTotalChunkedMessages() {
        return this.totalChunkedMessages;
    }

    @Generated
    public void setTotalMessages(int totalMessages) {
        this.totalMessages = totalMessages;
    }

    @Generated
    public void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    @Generated
    public void setTotalChunkedMessages(int totalChunkedMessages) {
        this.totalChunkedMessages = totalChunkedMessages;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendMessageInfo)) {
            return false;
        }
        SendMessageInfo other = (SendMessageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalMessages() != other.getTotalMessages()) {
            return false;
        }
        if (this.getTotalBytes() != other.getTotalBytes()) {
            return false;
        }
        return this.getTotalChunkedMessages() == other.getTotalChunkedMessages();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SendMessageInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalMessages();
        long $totalBytes = this.getTotalBytes();
        result = result * 59 + (int)($totalBytes >>> 32 ^ $totalBytes);
        result = result * 59 + this.getTotalChunkedMessages();
        return result;
    }

    @Generated
    public String toString() {
        return "SendMessageInfo(totalMessages=" + this.getTotalMessages() + ", totalBytes=" + this.getTotalBytes() + ", totalChunkedMessages=" + this.getTotalChunkedMessages() + ")";
    }
}

