/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.server.service;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.bookkeeper.common.conf.ComponentConfiguration;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stream.server.conf.DLConfiguration;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorProviderService
extends AbstractLifecycleComponent<DLConfiguration>
implements Supplier<CuratorFramework> {
    private static final Logger log = LoggerFactory.getLogger(CuratorProviderService.class);
    private final String zkServers;
    private final RetryPolicy curatorRetryPolicy;
    private final CuratorFramework curatorClient;

    public CuratorProviderService(ServerConfiguration bkServerConf, DLConfiguration conf, StatsLogger statsLogger) {
        super("curator-provider", (ComponentConfiguration)conf, statsLogger);
        this.zkServers = ZKMetadataDriverBase.resolveZkServers((AbstractConfiguration)bkServerConf);
        this.curatorRetryPolicy = new ExponentialBackoffRetry(bkServerConf.getZkRetryBackoffStartMs(), Integer.MAX_VALUE, bkServerConf.getZkRetryBackoffMaxMs());
        this.curatorClient = CuratorFrameworkFactory.newClient((String)this.zkServers, (RetryPolicy)this.curatorRetryPolicy);
    }

    protected void doStart() {
        this.curatorClient.start();
        log.info("Provided curator clients to zookeeper {}.", (Object)this.zkServers);
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
        this.curatorClient.close();
    }

    @Override
    public CuratorFramework get() {
        return this.curatorClient;
    }
}

