/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.util.Arrays;
import org.apache.hadoop.util.RunJar;
import org.apache.pig.backend.hadoop.executionengine.JobCreationException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.RunJarSecurityManager;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.tez.TezPigScriptStats;

public class NativeTezOper
extends TezOperator {
    private static final long serialVersionUID = 1L;
    private static int countJobs = 0;
    private String nativeTezJar;
    private String[] params;
    private String jobId;

    public NativeTezOper(OperatorKey k, String tezJar, String[] parameters) {
        super(k);
        this.nativeTezJar = tezJar;
        this.params = parameters;
        this.jobId = this.nativeTezJar + "_" + NativeTezOper.getJobNumber();
    }

    private static int getJobNumber() {
        return ++countJobs;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getCommandString() {
        StringBuilder sb = new StringBuilder("hadoop jar ");
        sb.append(this.nativeTezJar);
        for (String pr : this.params) {
            sb.append(" ");
            sb.append(pr);
        }
        return sb.toString();
    }

    private String[] getNativeTezParams() {
        String[] paramArr = new String[this.params.length + 1];
        paramArr[0] = this.nativeTezJar;
        for (int i = 0; i < this.params.length; ++i) {
            paramArr[i + 1] = this.params[i];
        }
        return paramArr;
    }

    @Override
    public void visit(TezOpPlanVisitor v) throws VisitorException {
        v.visitTezOp(this);
    }

    public void runJob(String jobStatsKey) throws JobCreationException {
        RunJarSecurityManager secMan = new RunJarSecurityManager();
        try {
            RunJar.main((String[])this.getNativeTezParams());
            ((TezPigScriptStats)PigStats.get()).addTezJobStatsForNative(jobStatsKey, this, true);
        }
        catch (SecurityException se) {
            if (secMan.getExitInvoked()) {
                if (secMan.getExitCode() != 0) {
                    throw new JobCreationException("Native job returned with non-zero return code");
                }
                ((TezPigScriptStats)PigStats.get()).addTezJobStatsForNative(jobStatsKey, this, true);
            }
        }
        catch (Throwable t) {
            JobCreationException e = new JobCreationException("Cannot run native tez job " + t.getMessage(), t);
            ((TezPigScriptStats)PigStats.get()).addTezJobStatsForNative(jobStatsKey, this, false);
            throw e;
        }
        finally {
            secMan.retire();
        }
    }

    @Override
    public String name() {
        return "Tez - " + this.mKey.toString() + "\n Native Tez - jar : " + this.nativeTezJar + ", params: " + Arrays.toString(this.params);
    }
}

