/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.coordination.SplitLogWorkerCoordination;
import org.apache.hadoop.hbase.regionserver.LastSequenceId;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceAudience.Private
public class SplitLogWorker
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SplitLogWorker.class);
    Thread worker;
    private final SplitLogWorkerCoordination coordination;
    private final Configuration conf;
    private final RegionServerServices server;

    public SplitLogWorker(Server hserver, Configuration conf, RegionServerServices server, TaskExecutor splitTaskExecutor) {
        this.server = server;
        this.conf = conf;
        this.coordination = hserver.getCoordinatedStateManager().getSplitLogWorkerCoordination();
        this.coordination.init(server, conf, splitTaskExecutor, this);
    }

    public SplitLogWorker(Configuration conf, RegionServerServices server, LastSequenceId sequenceIdChecker, WALFactory factory) {
        this(server, conf, server, (String f, CancelableProgressable p) -> SplitLogWorker.splitLog(f, p, conf, server, sequenceIdChecker, factory));
    }

    static TaskExecutor.Status splitLog(String filename, CancelableProgressable p, Configuration conf, RegionServerServices server, LastSequenceId sequenceIdChecker, WALFactory factory) {
        FileSystem fs;
        Path walDir;
        try {
            walDir = CommonFSUtils.getWALRootDir((Configuration)conf);
            fs = walDir.getFileSystem(conf);
        }
        catch (IOException e) {
            LOG.warn("Resigning, could not find root dir or fs", (Throwable)e);
            return TaskExecutor.Status.RESIGNED;
        }
        try {
            SplitLogWorkerCoordination splitLogWorkerCoordination;
            SplitLogWorkerCoordination splitLogWorkerCoordination2 = splitLogWorkerCoordination = server.getCoordinatedStateManager() == null ? null : server.getCoordinatedStateManager().getSplitLogWorkerCoordination();
            if (!WALSplitter.splitLogFile(walDir, fs.getFileStatus(new Path(walDir, filename)), fs, conf, p, sequenceIdChecker, splitLogWorkerCoordination, factory, server)) {
                return TaskExecutor.Status.PREEMPTED;
            }
        }
        catch (InterruptedIOException iioe) {
            LOG.warn("Resigning, interrupted splitting WAL {}", (Object)filename, (Object)iioe);
            return TaskExecutor.Status.RESIGNED;
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                LOG.warn("Done, WAL {} does not exist anymore", (Object)filename, (Object)e);
                return TaskExecutor.Status.DONE;
            }
            Throwable cause = e.getCause();
            if (e instanceof RetriesExhaustedException && (cause instanceof NotServingRegionException || cause instanceof ConnectException || cause instanceof SocketTimeoutException)) {
                LOG.warn("Resigning, can't connect to target regionserver splitting WAL {}", (Object)filename, (Object)e);
                return TaskExecutor.Status.RESIGNED;
            }
            if (cause instanceof InterruptedException) {
                LOG.warn("Resigning, interrupted splitting WAL {}", (Object)filename, (Object)e);
                return TaskExecutor.Status.RESIGNED;
            }
            LOG.warn("Error splitting WAL {}", (Object)filename, (Object)e);
            return TaskExecutor.Status.ERR;
        }
        LOG.debug("Done splitting WAL {}", (Object)filename);
        return TaskExecutor.Status.DONE;
    }

    @Override
    public void run() {
        try {
            LOG.info("SplitLogWorker " + this.server.getServerName() + " starting");
            this.coordination.registerListener();
            boolean res = false;
            while (!res && !this.coordination.isStop()) {
                res = this.coordination.isReady();
            }
            if (!this.coordination.isStop()) {
                this.coordination.taskLoop();
            }
        }
        catch (Throwable t) {
            if (ExceptionUtil.isInterrupt((Throwable)t)) {
                LOG.info("SplitLogWorker interrupted. Exiting. " + (this.coordination.isStop() ? "" : " (ERROR: exitWorker is not set, exiting anyway)"));
            } else {
                LOG.error("unexpected error ", t);
            }
        }
        finally {
            this.coordination.removeListener();
            LOG.info("SplitLogWorker " + this.server.getServerName() + " exiting");
        }
    }

    public void stopTask() {
        LOG.info("Sending interrupt to stop the worker thread");
        this.worker.interrupt();
    }

    public void start() {
        this.worker = new Thread(null, this, "SplitLogWorker-" + this.server.getServerName().toShortString());
        this.worker.start();
    }

    public void stop() {
        this.coordination.stopProcessingTasks();
        this.stopTask();
    }

    public int getTaskReadySeq() {
        return this.coordination.getTaskReadySeq();
    }

    public static interface TaskExecutor {
        public Status exec(String var1, CancelableProgressable var2);

        public static enum Status {
            DONE,
            ERR,
            RESIGNED,
            PREEMPTED;

        }
    }
}

