/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MockRegionServerServices;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hadoop.hbase.coprocessor.HasRegionServerServices;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={CoprocessorTests.class, SmallTests.class})
public class TestCoreRegionCoprocessor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCoreRegionCoprocessor.class);
    @Rule
    public TestName name = new TestName();
    HBaseTestingUtility HTU = HBaseTestingUtility.createLocalHTU();
    private HRegion region = null;
    private RegionServerServices rss;

    @Before
    public void before() throws IOException {
        String methodName = this.name.getMethodName();
        TableName tn = TableName.valueOf((String)methodName);
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)methodName)).build();
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tn).setColumnFamily(cfd).build();
        RegionInfo ri = RegionInfoBuilder.newBuilder((TableName)tn).build();
        this.rss = new MockRegionServerServices(this.HTU.getConfiguration());
        this.region = HRegion.openHRegion((RegionInfo)ri, (TableDescriptor)td, null, (Configuration)this.HTU.getConfiguration(), (RegionServerServices)this.rss, null);
    }

    @After
    public void after() throws IOException {
        this.region.close();
    }

    @Test
    public void testCoreRegionCoprocessor() throws IOException {
        RegionCoprocessorHost rch = this.region.getCoprocessorHost();
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)rch.load(null, NotCoreRegionCoprocessor.class.getName(), 0, this.HTU.getConfiguration());
        Assert.assertFalse((boolean)(env instanceof HasRegionServerServices));
        env = (RegionCoprocessorEnvironment)rch.load(null, CoreRegionCoprocessor.class.getName(), 1, this.HTU.getConfiguration());
        Assert.assertTrue((boolean)(env instanceof HasRegionServerServices));
        Assert.assertEquals((Object)this.rss, (Object)((HasRegionServerServices)env).getRegionServerServices());
    }

    @CoreCoprocessor
    public static class CoreRegionCoprocessor
    implements RegionCoprocessor {
    }

    public static class NotCoreRegionCoprocessor
    implements RegionCoprocessor {
    }
}

