/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.wm;

import org.apache.hadoop.hive.ql.wm.CounterLimit;

public class TimeCounterLimit
implements CounterLimit {
    private TimeCounter timeCounter;
    private long limit;

    TimeCounterLimit(TimeCounter timeCounter, long limit) {
        this.timeCounter = timeCounter;
        this.limit = limit;
    }

    @Override
    public String getName() {
        return this.timeCounter.name();
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    public CounterLimit clone() {
        return new TimeCounterLimit(this.timeCounter, this.limit);
    }

    public String toString() {
        return "counter: " + this.timeCounter.name() + " limit: " + this.limit;
    }

    public int hashCode() {
        int hash = 31 * this.timeCounter.hashCode();
        hash = (int)((long)hash + 31L * this.limit);
        return 31 * hash;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof TimeCounterLimit)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        TimeCounterLimit otherTcl = (TimeCounterLimit)other;
        return this.timeCounter.equals((Object)otherTcl.timeCounter) && this.limit == otherTcl.limit;
    }

    public static enum TimeCounter {
        ELAPSED_TIME,
        EXECUTION_TIME;

    }
}

