/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.persistence;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.Connection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.ozone.recon.api.types.UnhealthyContainersSummary;
import org.apache.ozone.recon.schema.ContainerSchemaDefinition;
import org.apache.ozone.recon.schema.generated.tables.UnhealthyContainersTable;
import org.apache.ozone.recon.schema.generated.tables.daos.UnhealthyContainersDao;
import org.apache.ozone.recon.schema.generated.tables.pojos.UnhealthyContainers;
import org.apache.ozone.recon.schema.generated.tables.records.UnhealthyContainersRecord;
import org.jooq.Condition;
import org.jooq.Cursor;
import org.jooq.DSLContext;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.SelectQuery;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ContainerHealthSchemaManager {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerHealthSchemaManager.class);
    private final UnhealthyContainersDao unhealthyContainersDao;
    private final ContainerSchemaDefinition containerSchemaDefinition;

    @Inject
    public ContainerHealthSchemaManager(ContainerSchemaDefinition containerSchemaDefinition, UnhealthyContainersDao unhealthyContainersDao) {
        this.unhealthyContainersDao = unhealthyContainersDao;
        this.containerSchemaDefinition = containerSchemaDefinition;
    }

    public List<UnhealthyContainers> getUnhealthyContainers(ContainerSchemaDefinition.UnHealthyContainerStates state, Long minContainerId, Optional<Long> maxContainerId, int limit) {
        OrderField[] orderField;
        Condition containerCondition;
        DSLContext dslContext = this.containerSchemaDefinition.getDSLContext();
        SelectQuery query = dslContext.selectQuery();
        query.addFrom((TableLike)UnhealthyContainersTable.UNHEALTHY_CONTAINERS);
        if (maxContainerId.isPresent() && maxContainerId.get() > 0L) {
            containerCondition = UnhealthyContainersTable.UNHEALTHY_CONTAINERS.CONTAINER_ID.lessThan((Object)maxContainerId.get());
            orderField = new OrderField[]{UnhealthyContainersTable.UNHEALTHY_CONTAINERS.CONTAINER_ID.desc(), UnhealthyContainersTable.UNHEALTHY_CONTAINERS.CONTAINER_STATE.asc()};
        } else {
            containerCondition = UnhealthyContainersTable.UNHEALTHY_CONTAINERS.CONTAINER_ID.greaterThan((Object)minContainerId);
            orderField = new OrderField[]{UnhealthyContainersTable.UNHEALTHY_CONTAINERS.CONTAINER_ID.asc(), UnhealthyContainersTable.UNHEALTHY_CONTAINERS.CONTAINER_STATE.asc()};
        }
        if (state != null) {
            if (state.equals((Object)ContainerSchemaDefinition.UnHealthyContainerStates.ALL_REPLICAS_BAD)) {
                query.addConditions(containerCondition.and(UnhealthyContainersTable.UNHEALTHY_CONTAINERS.CONTAINER_STATE.eq((Object)ContainerSchemaDefinition.UnHealthyContainerStates.UNDER_REPLICATED.toString())));
                query.addConditions(UnhealthyContainersTable.UNHEALTHY_CONTAINERS.ACTUAL_REPLICA_COUNT.eq((Object)0));
            } else {
                query.addConditions(containerCondition.and(UnhealthyContainersTable.UNHEALTHY_CONTAINERS.CONTAINER_STATE.eq((Object)state.toString())));
            }
        } else {
            query.addConditions(containerCondition);
        }
        query.addOrderBy(orderField);
        query.addLimit(limit);
        return query.fetchInto(UnhealthyContainers.class).stream().sorted(Comparator.comparingLong(UnhealthyContainers::getContainerId)).collect(Collectors.toList());
    }

    public List<UnhealthyContainersSummary> getUnhealthyContainersSummary() {
        DSLContext dslContext = this.containerSchemaDefinition.getDSLContext();
        return dslContext.select((SelectField)UnhealthyContainersTable.UNHEALTHY_CONTAINERS.CONTAINER_STATE.as("containerState"), (SelectField)DSL.count().as("cnt")).from((TableLike)UnhealthyContainersTable.UNHEALTHY_CONTAINERS).groupBy(new GroupField[]{UnhealthyContainersTable.UNHEALTHY_CONTAINERS.CONTAINER_STATE}).fetchInto(UnhealthyContainersSummary.class);
    }

    public Cursor<UnhealthyContainersRecord> getAllUnhealthyRecordsCursor() {
        DSLContext dslContext = this.containerSchemaDefinition.getDSLContext();
        return dslContext.selectFrom((Table)UnhealthyContainersTable.UNHEALTHY_CONTAINERS).orderBy((OrderField)UnhealthyContainersTable.UNHEALTHY_CONTAINERS.CONTAINER_ID.asc()).fetchLazy();
    }

    public void insertUnhealthyContainerRecords(List<UnhealthyContainers> recs) {
        if (LOG.isDebugEnabled()) {
            recs.forEach(rec -> LOG.debug("rec.getContainerId() : {}, rec.getContainerState(): {}", (Object)rec.getContainerId(), (Object)rec.getContainerState()));
        }
        try (Connection connection = this.containerSchemaDefinition.getDataSource().getConnection();){
            connection.setAutoCommit(false);
            try {
                for (UnhealthyContainers rec2 : recs) {
                    try {
                        this.unhealthyContainersDao.insert(rec2);
                    }
                    catch (DataAccessException dataAccessException) {
                        this.unhealthyContainersDao.update(rec2);
                        LOG.debug("Error while inserting unhealthy container record: {}", (Object)rec2, (Object)dataAccessException);
                    }
                }
                connection.commit();
            }
            catch (Exception innerException) {
                connection.rollback();
                LOG.error("Transaction rolled back due to error", (Throwable)innerException);
                throw innerException;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to insert records into {} ", (Object)"UNHEALTHY_CONTAINERS", (Object)e);
            throw new RuntimeException("Recon failed to insert " + recs.size() + " unhealthy container records.", e);
        }
    }

    @VisibleForTesting
    public void clearAllUnhealthyContainerRecords() {
        DSLContext dslContext = this.containerSchemaDefinition.getDSLContext();
        try {
            dslContext.deleteFrom((Table)UnhealthyContainersTable.UNHEALTHY_CONTAINERS).execute();
            LOG.info("Cleared all unhealthy container records");
        }
        catch (Exception e) {
            LOG.info("Failed to clear unhealthy container records", (Throwable)e);
        }
    }
}

