/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.recon.api.AdminOnly;
import org.apache.hadoop.ozone.recon.api.types.BucketObjectDBInfo;
import org.apache.hadoop.ozone.recon.api.types.BucketsResponse;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;

@Path(value="/buckets")
@Produces(value={"application/json"})
@AdminOnly
public class BucketEndpoint {
    @Inject
    private ReconOMMetadataManager omMetadataManager;

    @Inject
    public BucketEndpoint(ReconOMMetadataManager omMetadataManager) {
        this.omMetadataManager = omMetadataManager;
    }

    @GET
    public Response getBuckets(@QueryParam(value="volume") String volume, @DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="prevKey") String prevKey) throws IOException {
        List<OmBucketInfo> buckets = this.omMetadataManager.listBucketsUnderVolume(volume, prevKey, limit);
        List<BucketObjectDBInfo> bucketMetadata = buckets.stream().map(BucketObjectDBInfo::new).collect(Collectors.toList());
        BucketsResponse bucketsResponse = new BucketsResponse(buckets.size(), bucketMetadata);
        return Response.ok((Object)bucketsResponse).build();
    }
}

