/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node.states;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;

public class Node2PipelineMap {
    private final Map<DatanodeID, Set<PipelineID>> dn2PipelineMap = new ConcurrentHashMap<DatanodeID, Set<PipelineID>>();

    public Set<PipelineID> getPipelines(@Nonnull DatanodeID datanode) {
        Set<PipelineID> s = this.dn2PipelineMap.get(datanode);
        return s != null ? new HashSet<PipelineID>(s) : Collections.emptySet();
    }

    public int getPipelinesCount(DatanodeID datanode) {
        return this.getPipelines(datanode).size();
    }

    public void addPipeline(Pipeline pipeline) {
        for (DatanodeDetails details : pipeline.getNodes()) {
            DatanodeID dnId = details.getID();
            this.dn2PipelineMap.computeIfAbsent(dnId, k -> ConcurrentHashMap.newKeySet()).add(pipeline.getId());
        }
    }

    public void removePipeline(Pipeline pipeline) {
        for (DatanodeDetails details : pipeline.getNodes()) {
            DatanodeID dnId = details.getID();
            this.dn2PipelineMap.computeIfPresent(dnId, (k, v) -> {
                v.remove(pipeline.getId());
                return v;
            });
        }
    }
}

