/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.util;

import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public enum S3StorageType {
    REDUCED_REDUNDANCY((ReplicationConfig)RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ONE)),
    STANDARD((ReplicationConfig)RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE)),
    STANDARD_IA((ReplicationConfig)new ECReplicationConfig(3, 2));

    private final ReplicationConfig replicationConfig;

    private S3StorageType(ReplicationConfig replicationConfig) {
        this.replicationConfig = replicationConfig;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public static S3StorageType fromReplicationConfig(ReplicationConfig config) {
        if (config.getReplicationType() == HddsProtos.ReplicationType.EC) {
            return STANDARD_IA;
        }
        if (config.getReplicationType() == HddsProtos.ReplicationType.STAND_ALONE || config.getRequiredNodes() == 1) {
            return REDUCED_REDUNDANCY;
        }
        return STANDARD;
    }
}

