/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import java.io.IOException;
import javax.annotation.PreDestroy;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.s3.OzoneClientCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class OzoneClientProducer {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneClientProducer.class);
    private OzoneClient client;
    @Inject
    private OzoneClientCache clientCache;

    @Produces
    public OzoneClient createClient() {
        this.client = this.clientCache.getClient();
        return this.client;
    }

    @PreDestroy
    public void destroy() throws IOException {
        LOG.debug("{}: Clearing thread-local auth", (Object)this);
        this.client.getObjectStore().getClientProxy().clearThreadLocalS3Auth();
    }
}

