/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class EmptyContentTypeFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if ("".equals(httpRequest.getContentType())) {
            chain.doFilter((ServletRequest)new HttpServletRequestWrapper(httpRequest){

                public String getContentType() {
                    return null;
                }

                public String getHeader(String name) {
                    if (name.equalsIgnoreCase("Content-Type")) {
                        return null;
                    }
                    return super.getHeader(name);
                }

                public Enumeration<String> getHeaders(String name) {
                    if ("Content-Type".equalsIgnoreCase(name)) {
                        return null;
                    }
                    return super.getHeaders(name);
                }

                public Enumeration<String> getHeaderNames() {
                    return new EnumerationWrapper(super.getHeaderNames());
                }
            }, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    public static class EnumerationWrapper
    implements Enumeration<String> {
        private final Enumeration<String> original;
        private String nextElement;

        public EnumerationWrapper(Enumeration<String> original) {
            this.original = original;
            this.step();
        }

        private void step() {
            this.nextElement = this.original.hasMoreElements() ? this.original.nextElement() : null;
            if ("Content-Type".equalsIgnoreCase(this.nextElement)) {
                this.nextElement = this.original.hasMoreElements() ? this.original.nextElement() : null;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.nextElement != null;
        }

        @Override
        public String nextElement() {
            if (this.nextElement == null) {
                throw new NoSuchElementException();
            }
            String returnValue = this.nextElement;
            this.step();
            return returnValue;
        }
    }
}

