/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import io.opentelemetry.api.trace.Span;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.container.common.helpers.BlockNotCommittedException;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerNotOpenException;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.common.ChecksumData;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.function.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContainerProtocolCalls {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerProtocolCalls.class);
    private static final List<XceiverClientSpi.Validator> VALIDATORS = ContainerProtocolCalls.createValidators();

    private ContainerProtocolCalls() {
    }

    public static ContainerProtos.ListBlockResponseProto listBlock(XceiverClientSpi xceiverClient, long containerID, Long startLocalID, int count, Token<? extends TokenIdentifier> token) throws IOException {
        String traceId;
        ContainerProtos.ListBlockRequestProto.Builder listBlockBuilder = ContainerProtos.ListBlockRequestProto.newBuilder().setCount(count);
        if (startLocalID != null) {
            listBlockBuilder.setStartLocalID(startLocalID.longValue());
        }
        String datanodeID = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.ListBlock).setContainerID(containerID).setDatanodeUuid(datanodeID).setListBlock(listBlockBuilder.build());
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        if ((traceId = TracingUtil.exportCurrentSpan()) != null) {
            builder.setTraceID(traceId);
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getListBlock();
    }

    static <T> T tryEachDatanode(Pipeline pipeline, CheckedFunction<DatanodeDetails, T, IOException> op, Function<DatanodeDetails, String> toErrorMessage) throws IOException {
        HashSet<DatanodeDetails> excluded = new HashSet<DatanodeDetails>();
        while (true) {
            DatanodeDetails d = pipeline.getClosestNode(excluded);
            try {
                return (T)op.apply((Object)d);
            }
            catch (IOException e) {
                StorageContainerException sce;
                Span span = TracingUtil.getActiveSpan();
                if (e instanceof StorageContainerException && (sce = (StorageContainerException)e).getResult() == ContainerProtos.Result.BLOCK_TOKEN_VERIFICATION_FAILED) {
                    span.addEvent("block token verification failed at DN " + d);
                    throw e;
                }
                span.addEvent("failed to connect to DN " + d);
                excluded.add(d);
                if (excluded.size() < pipeline.size()) {
                    LOG.warn(toErrorMessage.apply(d) + "; will try another datanode.", (Throwable)e);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public static ContainerProtos.GetBlockResponseProto getBlock(XceiverClientSpi xceiverClient, List<XceiverClientSpi.Validator> validators, BlockID blockID, Token<? extends TokenIdentifier> token, Map<DatanodeDetails, Integer> replicaIndexes) throws IOException {
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetBlock).setContainerID(blockID.getContainerID());
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        return (ContainerProtos.GetBlockResponseProto)ContainerProtocolCalls.tryEachDatanode(xceiverClient.getPipeline(), d -> ContainerProtocolCalls.getBlock(xceiverClient, validators, builder, blockID, d, replicaIndexes), d -> ContainerProtocolCalls.toErrorMessage(blockID, d));
    }

    static String toErrorMessage(BlockID blockId, DatanodeDetails d) {
        return String.format("Failed to get block #%s in container #%s from %s", blockId.getLocalID(), blockId.getContainerID(), d);
    }

    public static ContainerProtos.GetBlockResponseProto getBlock(XceiverClientSpi xceiverClient, BlockID datanodeBlockID, Token<? extends TokenIdentifier> token, Map<DatanodeDetails, Integer> replicaIndexes) throws IOException {
        return ContainerProtocolCalls.getBlock(xceiverClient, ContainerProtocolCalls.getValidatorList(), datanodeBlockID, token, replicaIndexes);
    }

    private static ContainerProtos.GetBlockResponseProto getBlock(XceiverClientSpi xceiverClient, List<XceiverClientSpi.Validator> validators, ContainerProtos.ContainerCommandRequestProto.Builder builder, BlockID blockID, DatanodeDetails datanode, Map<DatanodeDetails, Integer> replicaIndexes) throws IOException {
        String traceId = TracingUtil.exportCurrentSpan();
        if (traceId != null) {
            builder.setTraceID(traceId);
        }
        ContainerProtos.DatanodeBlockID.Builder datanodeBlockID = blockID.getDatanodeBlockIDProtobufBuilder();
        int replicaIndex = replicaIndexes.getOrDefault(datanode, 0);
        if (replicaIndex > 0) {
            datanodeBlockID.setReplicaIndex(replicaIndex);
        }
        ContainerProtos.GetBlockRequestProto.Builder readBlockRequest = ContainerProtos.GetBlockRequestProto.newBuilder().setBlockID(datanodeBlockID.build());
        ContainerProtos.ContainerCommandRequestProto request = builder.setDatanodeUuid(datanode.getUuidString()).setGetBlock(readBlockRequest).build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request, validators);
        return response.getGetBlock();
    }

    public static ContainerProtos.GetCommittedBlockLengthResponseProto getCommittedBlockLength(XceiverClientSpi xceiverClient, BlockID blockID, Token<OzoneBlockTokenIdentifier> token) throws IOException {
        String traceId;
        ContainerProtos.GetCommittedBlockLengthRequestProto.Builder getBlockLengthRequestBuilder = ContainerProtos.GetCommittedBlockLengthRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf());
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetCommittedBlockLength).setContainerID(blockID.getContainerID()).setDatanodeUuid(id).setGetCommittedBlockLength(getBlockLengthRequestBuilder);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        if ((traceId = TracingUtil.exportCurrentSpan()) != null) {
            builder.setTraceID(traceId);
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getGetCommittedBlockLength();
    }

    public static XceiverClientReply putBlockAsync(XceiverClientSpi xceiverClient, ContainerProtos.BlockData containerBlockData, boolean eof, String tokenString) throws IOException, InterruptedException, ExecutionException {
        ContainerProtos.ContainerCommandRequestProto request = ContainerProtocolCalls.getPutBlockRequest(xceiverClient.getPipeline(), containerBlockData, eof, tokenString);
        return xceiverClient.sendCommandAsync(request);
    }

    public static ContainerProtos.FinalizeBlockResponseProto finalizeBlock(XceiverClientSpi xceiverClient, ContainerProtos.DatanodeBlockID blockID, Token<OzoneBlockTokenIdentifier> token) throws IOException {
        ContainerProtos.FinalizeBlockRequestProto.Builder finalizeBlockRequest = ContainerProtos.FinalizeBlockRequestProto.newBuilder().setBlockID(blockID);
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.FinalizeBlock).setContainerID(blockID.getContainerID()).setDatanodeUuid(id).setFinalizeBlock(finalizeBlockRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getFinalizeBlock();
    }

    public static ContainerProtos.ContainerCommandRequestProto getPutBlockRequest(Pipeline pipeline, ContainerProtos.BlockData containerBlockData, boolean eof, String tokenString) throws IOException {
        ContainerProtos.PutBlockRequestProto.Builder createBlockRequest = ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(containerBlockData).setEof(eof);
        String id = pipeline.getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.PutBlock).setContainerID(containerBlockData.getBlockID().getContainerID()).setDatanodeUuid(id).setPutBlock(createBlockRequest);
        if (tokenString != null) {
            builder.setEncodedToken(tokenString);
        }
        return builder.build();
    }

    public static ContainerProtos.ReadChunkResponseProto readChunk(XceiverClientSpi xceiverClient, ContainerProtos.ChunkInfo chunk, ContainerProtos.DatanodeBlockID blockID, List<XceiverClientSpi.Validator> validators, Token<? extends TokenIdentifier> token) throws IOException {
        ContainerProtos.ReadChunkRequestProto.Builder readChunkRequest = ContainerProtos.ReadChunkRequestProto.newBuilder().setBlockID(blockID).setChunkData(chunk).setReadChunkVersion(ContainerProtos.ReadChunkVersion.V1);
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.ReadChunk).setContainerID(blockID.getContainerID()).setReadChunk(readChunkRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        try (TracingUtil.TraceCloseable ignored = TracingUtil.createActivatedSpan("readChunk");){
            Span span = TracingUtil.getActiveSpan();
            span.setAttribute("offset", chunk.getOffset()).setAttribute("length", chunk.getLen()).setAttribute("block", blockID.toString());
            ContainerProtos.ReadChunkResponseProto readChunkResponseProto = (ContainerProtos.ReadChunkResponseProto)ContainerProtocolCalls.tryEachDatanode(xceiverClient.getPipeline(), d -> ContainerProtocolCalls.readChunk(xceiverClient, chunk, blockID, validators, builder, d), d -> ContainerProtocolCalls.toErrorMessage(chunk, blockID, d));
            return readChunkResponseProto;
        }
    }

    private static ContainerProtos.ReadChunkResponseProto readChunk(XceiverClientSpi xceiverClient, ContainerProtos.ChunkInfo chunk, ContainerProtos.DatanodeBlockID blockID, List<XceiverClientSpi.Validator> validators, ContainerProtos.ContainerCommandRequestProto.Builder builder, DatanodeDetails d) throws IOException {
        ContainerProtos.ContainerCommandResponseProto reply;
        ContainerProtos.ReadChunkResponseProto response;
        long readLen;
        ContainerProtos.ContainerCommandRequestProto.Builder requestBuilder = builder.setDatanodeUuid(d.getUuidString());
        String traceId = TracingUtil.exportCurrentSpan();
        if (traceId != null) {
            requestBuilder = requestBuilder.setTraceID(traceId);
        }
        if ((readLen = ContainerProtocolCalls.getLen(response = (reply = xceiverClient.sendCommand(requestBuilder.build(), validators)).getReadChunk())) != chunk.getLen()) {
            throw new IOException(ContainerProtocolCalls.toErrorMessage(chunk, blockID, d) + ": readLen=" + readLen);
        }
        return response;
    }

    static String toErrorMessage(ContainerProtos.ChunkInfo chunk, ContainerProtos.DatanodeBlockID blockId, DatanodeDetails d) {
        return String.format("Failed to read chunk %s (len=%s) %s from %s", chunk.getChunkName(), chunk.getLen(), blockId, d);
    }

    static long getLen(ContainerProtos.ReadChunkResponseProto response) {
        if (response.hasData()) {
            return response.getData().size();
        }
        if (response.hasDataBuffers()) {
            return response.getDataBuffers().getBuffersList().stream().mapToLong(ByteString::size).sum();
        }
        return -1L;
    }

    public static XceiverClientReply writeChunkAsync(XceiverClientSpi xceiverClient, ContainerProtos.ChunkInfo chunk, BlockID blockID, ByteString data, String tokenString, int replicationIndex, ContainerProtos.BlockData blockData, boolean close) throws IOException, ExecutionException, InterruptedException {
        ContainerProtos.WriteChunkRequestProto.Builder writeChunkRequest = ContainerProtos.WriteChunkRequestProto.newBuilder().setBlockID(ContainerProtos.DatanodeBlockID.newBuilder().setContainerID(blockID.getContainerID()).setLocalID(blockID.getLocalID()).setBlockCommitSequenceId(blockID.getBlockCommitSequenceId()).setReplicaIndex(replicationIndex).build()).setChunkData(chunk).setData(data);
        if (blockData != null) {
            ContainerProtos.PutBlockRequestProto.Builder createBlockRequest = ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(blockData).setEof(close);
            writeChunkRequest.setBlock(createBlockRequest);
        }
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.WriteChunk).setContainerID(blockID.getContainerID()).setDatanodeUuid(id).setWriteChunk(writeChunkRequest);
        if (tokenString != null) {
            builder.setEncodedToken(tokenString);
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        return xceiverClient.sendCommandAsync(request);
    }

    public static ContainerProtos.PutSmallFileResponseProto writeSmallFile(XceiverClientSpi client, BlockID blockID, byte[] data, Token<OzoneBlockTokenIdentifier> token) throws IOException {
        ContainerProtos.BlockData containerBlockData = ContainerProtos.BlockData.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).build();
        ContainerProtos.PutBlockRequestProto.Builder createBlockRequest = ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(containerBlockData);
        ContainerProtos.KeyValue keyValue = ContainerProtos.KeyValue.newBuilder().setKey("OverWriteRequested").setValue("true").build();
        Checksum checksum = new Checksum(ContainerProtos.ChecksumType.CRC32, 256);
        ChecksumData checksumData = checksum.computeChecksum(data);
        ContainerProtos.ChunkInfo chunk = ContainerProtos.ChunkInfo.newBuilder().setChunkName(blockID.getLocalID() + "_chunk").setOffset(0L).setLen((long)data.length).addMetadata(keyValue).setChecksumData(checksumData.getProtoBufMessage()).build();
        ContainerProtos.PutSmallFileRequestProto putSmallFileRequest = ContainerProtos.PutSmallFileRequestProto.newBuilder().setChunkInfo(chunk).setBlock(createBlockRequest).setData(ByteString.copyFrom((byte[])data)).build();
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.PutSmallFile).setContainerID(blockID.getContainerID()).setDatanodeUuid(id).setPutSmallFile(putSmallFileRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getPutSmallFile();
    }

    @InterfaceStability.Evolving
    public static void createRecoveringContainer(XceiverClientSpi client, long containerID, String encodedToken, int replicaIndex) throws IOException {
        ContainerProtocolCalls.createContainer(client, containerID, encodedToken, ContainerProtos.ContainerDataProto.State.RECOVERING, replicaIndex);
    }

    public static void createContainer(XceiverClientSpi client, long containerID, String encodedToken) throws IOException {
        ContainerProtocolCalls.createContainer(client, containerID, encodedToken, null, 0);
    }

    public static void createContainer(XceiverClientSpi client, long containerID, String encodedToken, ContainerProtos.ContainerDataProto.State state, int replicaIndex) throws IOException {
        String traceId;
        ContainerProtos.CreateContainerRequestProto.Builder createRequest = ContainerProtos.CreateContainerRequestProto.newBuilder();
        createRequest.setContainerType(ContainerProtos.ContainerType.KeyValueContainer);
        if (state != null) {
            createRequest.setState(state);
        }
        if (replicaIndex > 0) {
            createRequest.setReplicaIndex(replicaIndex);
        }
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        if ((traceId = TracingUtil.exportCurrentSpan()) != null) {
            request.setTraceID(traceId);
        }
        request.setCmdType(ContainerProtos.Type.CreateContainer);
        request.setContainerID(containerID);
        request.setCreateContainer(createRequest.build());
        request.setDatanodeUuid(id);
        client.sendCommand(request.build(), ContainerProtocolCalls.getValidatorList());
    }

    public static void deleteContainer(XceiverClientSpi client, long containerID, boolean force, String encodedToken) throws IOException {
        String traceId;
        ContainerProtos.DeleteContainerRequestProto.Builder deleteRequest = ContainerProtos.DeleteContainerRequestProto.newBuilder();
        deleteRequest.setForceDelete(force);
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.DeleteContainer);
        request.setContainerID(containerID);
        request.setDeleteContainer(deleteRequest);
        request.setDatanodeUuid(id);
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        if ((traceId = TracingUtil.exportCurrentSpan()) != null) {
            request.setTraceID(traceId);
        }
        client.sendCommand(request.build(), ContainerProtocolCalls.getValidatorList());
    }

    public static void closeContainer(XceiverClientSpi client, long containerID, String encodedToken) throws IOException {
        String traceId;
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.CloseContainer);
        request.setContainerID(containerID);
        request.setCloseContainer(ContainerProtos.CloseContainerRequestProto.getDefaultInstance());
        request.setDatanodeUuid(id);
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        if ((traceId = TracingUtil.exportCurrentSpan()) != null) {
            request.setTraceID(traceId);
        }
        client.sendCommand(request.build(), ContainerProtocolCalls.getValidatorList());
    }

    public static ContainerProtos.ReadContainerResponseProto readContainer(XceiverClientSpi client, long containerID, String encodedToken) throws IOException {
        String traceId;
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.ReadContainer);
        request.setContainerID(containerID);
        request.setReadContainer(ContainerProtos.ReadContainerRequestProto.getDefaultInstance());
        request.setDatanodeUuid(id);
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        if ((traceId = TracingUtil.exportCurrentSpan()) != null) {
            request.setTraceID(traceId);
        }
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request.build(), ContainerProtocolCalls.getValidatorList());
        return response.getReadContainer();
    }

    public static ContainerProtos.GetSmallFileResponseProto readSmallFile(XceiverClientSpi client, BlockID blockID, Token<OzoneBlockTokenIdentifier> token) throws IOException {
        String traceId;
        ContainerProtos.GetBlockRequestProto.Builder getBlock = ContainerProtos.GetBlockRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf());
        ContainerProtos.GetSmallFileRequestProto getSmallFileRequest = ContainerProtos.GetSmallFileRequestProto.newBuilder().setBlock(getBlock).setReadChunkVersion(ContainerProtos.ReadChunkVersion.V1).build();
        String id = client.getPipeline().getClosestNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetSmallFile).setContainerID(blockID.getContainerID()).setDatanodeUuid(id).setGetSmallFile(getSmallFileRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        if ((traceId = TracingUtil.exportCurrentSpan()) != null) {
            builder.setTraceID(traceId);
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getGetSmallFile();
    }

    public static ContainerProtos.EchoResponseProto echo(XceiverClientSpi client, String encodedContainerID, long containerID, ByteString payloadReqBytes, int payloadRespSizeKB, int sleepTimeMs, boolean readOnly) throws IOException {
        String traceId;
        ContainerProtos.EchoRequestProto getEcho = ContainerProtos.EchoRequestProto.newBuilder().setPayload(payloadReqBytes).setPayloadSizeResp(payloadRespSizeKB).setSleepTimeMs(sleepTimeMs).setReadOnly(readOnly).build();
        String id = client.getPipeline().getClosestNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.Echo).setContainerID(containerID).setDatanodeUuid(id).setEcho(getEcho);
        if (!encodedContainerID.isEmpty()) {
            builder.setEncodedToken(encodedContainerID);
        }
        if ((traceId = TracingUtil.exportCurrentSpan()) != null) {
            builder.setTraceID(traceId);
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getEcho();
    }

    public static ContainerProtos.GetContainerChecksumInfoResponseProto getContainerChecksumInfo(XceiverClientSpi client, long containerID, String encodedContainerID) throws IOException {
        String traceId;
        ContainerProtos.GetContainerChecksumInfoRequestProto containerChecksumRequestProto = ContainerProtos.GetContainerChecksumInfoRequestProto.newBuilder().setContainerID(containerID).build();
        String id = client.getPipeline().getClosestNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetContainerChecksumInfo).setContainerID(containerID).setDatanodeUuid(id).setGetContainerChecksumInfo(containerChecksumRequestProto);
        if (encodedContainerID != null) {
            builder.setEncodedToken(encodedContainerID);
        }
        if ((traceId = TracingUtil.exportCurrentSpan()) != null) {
            builder.setTraceID(traceId);
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getGetContainerChecksumInfo();
    }

    public static void validateContainerResponse(ContainerProtos.ContainerCommandResponseProto response) throws StorageContainerException {
        if (response.getResult() == ContainerProtos.Result.SUCCESS) {
            return;
        }
        if (response.getResult() == ContainerProtos.Result.BLOCK_NOT_COMMITTED) {
            throw new BlockNotCommittedException(response.getMessage());
        }
        if (response.getResult() == ContainerProtos.Result.CLOSED_CONTAINER_IO) {
            throw new ContainerNotOpenException(response.getMessage());
        }
        throw new StorageContainerException(response.getMessage(), response.getResult());
    }

    private static List<XceiverClientSpi.Validator> getValidatorList() {
        return VALIDATORS;
    }

    private static List<XceiverClientSpi.Validator> createValidators() {
        return Collections.singletonList((request, response) -> ContainerProtocolCalls.validateContainerResponse(response));
    }

    public static List<XceiverClientSpi.Validator> toValidatorList(XceiverClientSpi.Validator validator) {
        List<XceiverClientSpi.Validator> defaults = ContainerProtocolCalls.getValidatorList();
        ArrayList<XceiverClientSpi.Validator> validators = new ArrayList<XceiverClientSpi.Validator>(defaults.size() + 1);
        validators.addAll(defaults);
        validators.add(validator);
        return Collections.unmodifiableList(validators);
    }

    public static HashMap<DatanodeDetails, ContainerProtos.GetBlockResponseProto> getBlockFromAllNodes(XceiverClientSpi xceiverClient, ContainerProtos.DatanodeBlockID datanodeBlockID, Token<OzoneBlockTokenIdentifier> token) throws IOException, InterruptedException {
        String traceId;
        ContainerProtos.GetBlockRequestProto.Builder readBlockRequest = ContainerProtos.GetBlockRequestProto.newBuilder().setBlockID(datanodeBlockID);
        HashMap<DatanodeDetails, ContainerProtos.GetBlockResponseProto> datanodeToResponseMap = new HashMap<DatanodeDetails, ContainerProtos.GetBlockResponseProto>();
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetBlock).setContainerID(datanodeBlockID.getContainerID()).setDatanodeUuid(id).setGetBlock(readBlockRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        if ((traceId = TracingUtil.exportCurrentSpan()) != null) {
            builder.setTraceID(traceId);
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        Map<DatanodeDetails, ContainerProtos.ContainerCommandResponseProto> responses = xceiverClient.sendCommandOnAllNodes(request);
        for (Map.Entry<DatanodeDetails, ContainerProtos.ContainerCommandResponseProto> entry : responses.entrySet()) {
            datanodeToResponseMap.put(entry.getKey(), entry.getValue().getGetBlock());
        }
        return datanodeToResponseMap;
    }

    public static HashMap<DatanodeDetails, ContainerProtos.ReadContainerResponseProto> readContainerFromAllNodes(XceiverClientSpi client, long containerID, String encodedToken) throws IOException, InterruptedException {
        String traceId;
        String id = client.getPipeline().getFirstNode().getUuidString();
        HashMap<DatanodeDetails, ContainerProtos.ReadContainerResponseProto> datanodeToResponseMap = new HashMap<DatanodeDetails, ContainerProtos.ReadContainerResponseProto>();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.ReadContainer);
        request.setContainerID(containerID);
        request.setReadContainer(ContainerProtos.ReadContainerRequestProto.getDefaultInstance());
        request.setDatanodeUuid(id);
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        if ((traceId = TracingUtil.exportCurrentSpan()) != null) {
            request.setTraceID(traceId);
        }
        Map<DatanodeDetails, ContainerProtos.ContainerCommandResponseProto> responses = client.sendCommandOnAllNodes(request.build());
        for (Map.Entry<DatanodeDetails, ContainerProtos.ContainerCommandResponseProto> entry : responses.entrySet()) {
            datanodeToResponseMap.put(entry.getKey(), entry.getValue().getReadContainer());
        }
        return datanodeToResponseMap;
    }
}

