/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.DelegatingProperties;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.slf4j.Logger;

@InterfaceAudience.Private
public class OzoneConfiguration
extends Configuration
implements MutableConfigurationSource {
    public static final SortedSet<String> TAGS = Collections.unmodifiableSortedSet(Arrays.stream(ConfigTag.values()).map(Enum::name).collect(Collectors.toCollection(TreeSet::new)));
    private Properties delegatingProps;

    public static OzoneConfiguration of(ConfigurationSource source) {
        if (source instanceof LegacyHadoopConfigurationSource) {
            return new OzoneConfiguration(((LegacyHadoopConfigurationSource)source).getOriginalHadoopConfiguration());
        }
        return (OzoneConfiguration)source;
    }

    public static OzoneConfiguration of(OzoneConfiguration source) {
        return source;
    }

    public static OzoneConfiguration of(Configuration conf) {
        Preconditions.checkNotNull((Object)conf);
        return conf instanceof OzoneConfiguration ? (OzoneConfiguration)conf : new OzoneConfiguration(conf);
    }

    public static <T> T newInstanceOf(Class<T> configurationClass) {
        OzoneConfiguration conf = new OzoneConfiguration();
        return (T)conf.getObject(configurationClass);
    }

    public OzoneConfiguration() {
    }

    public OzoneConfiguration(Configuration conf) {
        super(conf);
    }

    public List<Property> readPropertyFromXml(URL url) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLConfiguration.class});
        Unmarshaller um = context.createUnmarshaller();
        XMLConfiguration config = (XMLConfiguration)um.unmarshal(url);
        return config.getProperties();
    }

    public static void activate() {
        String[] modules;
        OzoneConfiguration.addDefaultResource((String)"hdfs-default.xml");
        OzoneConfiguration.addDefaultResource((String)"hdfs-site.xml");
        for (String module : modules = new String[]{"hdds-common", "hdds-client", "hdds-container-service", "hdds-server-framework", "hdds-server-scm", "ozone-common", "ozone-csi", "ozone-manager", "ozone-recon"}) {
            OzoneConfiguration.addDefaultResource((String)(module + "-default.xml"));
        }
        OzoneConfiguration.addDefaultResource((String)"ozone-default.xml");
        OzoneConfiguration.addDefaultResource((String)"ozone-site.xml");
    }

    public Properties getAllPropertiesByTag(String tag) {
        Properties updatedProps = this.getProps();
        Properties propertiesByTag = super.getAllPropertiesByTag(tag);
        Properties props = new Properties();
        Enumeration<?> properties = propertiesByTag.propertyNames();
        while (properties.hasMoreElements()) {
            Object propertyName = properties.nextElement();
            String value = updatedProps.getProperty(propertyName.toString());
            if (value == null) continue;
            props.put(propertyName, value);
        }
        return props;
    }

    public Map<String, String> getOzoneProperties() {
        String ozoneRegex = ".*(ozone|hdds|ratis|container|scm|recon)\\..*";
        return this.getValByRegex(ozoneRegex);
    }

    public Collection<String> getConfigKeys() {
        return this.getProps().keySet().stream().map(Object::toString).collect(Collectors.toList());
    }

    public Map<String, String> getPropsMatchPrefixAndTrimPrefix(String keyPrefix) {
        Properties props = this.getProps();
        HashMap<String, String> configMap = new HashMap<String, String>();
        for (String name : props.stringPropertyNames()) {
            if (!name.startsWith(keyPrefix)) continue;
            String value = this.get(name);
            String keyName = name.substring(keyPrefix.length());
            configMap.put(keyName, value);
        }
        return configMap;
    }

    public boolean isPropertyTag(String tagStr) {
        return TAGS.contains(tagStr) || super.isPropertyTag(tagStr);
    }

    private static void addDeprecatedKeys() {
        Configuration.addDeprecations((Configuration.DeprecationDelta[])new Configuration.DeprecationDelta[]{new Configuration.DeprecationDelta("ozone.datanode.pipeline.limit", "ozone.scm.datanode.pipeline.limit"), new Configuration.DeprecationDelta("hdds.ratis.raft.server.rpcslowness.timeout", "hdds.ratis.raft.server.rpc.slowness.timeout"), new Configuration.DeprecationDelta("dfs.datanode.keytab.file", "hdds.datanode.kerberos.keytab.file"), new Configuration.DeprecationDelta("ozone.scm.chunk.layout", "ozone.scm.container.layout"), new Configuration.DeprecationDelta("hdds.datanode.replication.work.dir", "hdds.datanode.replication.work.dir"), new Configuration.DeprecationDelta("dfs.container.chunk.write.sync", "hdds.container.chunk.write.sync"), new Configuration.DeprecationDelta("dfs.container.ipc", "hdds.container.ipc.port"), new Configuration.DeprecationDelta("dfs.container.ipc.random.port", "hdds.container.ipc.random.port"), new Configuration.DeprecationDelta("dfs.container.ratis.admin.port", "hdds.container.ratis.admin.port"), new Configuration.DeprecationDelta("dfs.container.ratis.datanode.storage.dir", "hdds.container.ratis.datanode.storage.dir"), new Configuration.DeprecationDelta("dfs.container.ratis.datastream.enabled", "hdds.container.ratis.datastream.enabled"), new Configuration.DeprecationDelta("dfs.container.ratis.datastream.port", "hdds.container.ratis.datastream.port"), new Configuration.DeprecationDelta("dfs.container.ratis.datastream.random.port", "hdds.container.ratis.datastream.random.port"), new Configuration.DeprecationDelta("dfs.container.ratis.enabled", "hdds.container.ratis.enabled"), new Configuration.DeprecationDelta("dfs.container.ratis.ipc", "hdds.container.ratis.ipc.port"), new Configuration.DeprecationDelta("dfs.container.ratis.ipc.random.port", "hdds.container.ratis.ipc.random.port"), new Configuration.DeprecationDelta("dfs.container.ratis.leader.pending.bytes.limit", "hdds.container.ratis.leader.pending.bytes.limit"), new Configuration.DeprecationDelta("dfs.container.ratis.log.appender.queue.byte-limit", "hdds.container.ratis.log.appender.queue.byte-limit"), new Configuration.DeprecationDelta("dfs.container.ratis.log.appender.queue.num-elements", "hdds.container.ratis.log.appender.queue.num-elements"), new Configuration.DeprecationDelta("dfs.container.ratis.log.purge.gap", "hdds.container.ratis.log.purge.gap"), new Configuration.DeprecationDelta("dfs.container.ratis.log.queue.byte-limit", "hdds.container.ratis.log.queue.byte-limit"), new Configuration.DeprecationDelta("dfs.container.ratis.log.queue.num-elements", "hdds.container.ratis.log.queue.num-elements"), new Configuration.DeprecationDelta("dfs.container.ratis.num.container.op.executors", "hdds.container.ratis.num.container.op.executors"), new Configuration.DeprecationDelta("dfs.container.ratis.num.write.chunk.threads.per.volume", "hdds.container.ratis.num.write.chunk.threads.per.volume"), new Configuration.DeprecationDelta("dfs.container.ratis.rpc.type", "hdds.container.ratis.rpc.type"), new Configuration.DeprecationDelta("dfs.container.ratis.segment.preallocated.size", "hdds.container.ratis.segment.preallocated.size"), new Configuration.DeprecationDelta("dfs.container.ratis.segment.size", "hdds.container.ratis.segment.size"), new Configuration.DeprecationDelta("dfs.container.ratis.server.port", "hdds.container.ratis.server.port"), new Configuration.DeprecationDelta("dfs.container.ratis.statemachinedata.sync.retries", "hdds.container.ratis.statemachinedata.sync.retries"), new Configuration.DeprecationDelta("dfs.container.ratis.statemachinedata.sync.timeout", "hdds.container.ratis.statemachinedata.sync.timeout"), new Configuration.DeprecationDelta("dfs.container.ratis.statemachine.max.pending.apply-transactions", "hdds.container.ratis.statemachine.max.pending.apply-transactions"), new Configuration.DeprecationDelta("dfs.ratis.leader.election.minimum.timeout.duration", "hdds.ratis.leader.election.minimum.timeout.duration"), new Configuration.DeprecationDelta("dfs.ratis.server.retry-cache.timeout.duration", "hdds.ratis.server.retry-cache.timeout.duration"), new Configuration.DeprecationDelta("dfs.ratis.snapshot.threshold", "hdds.ratis.snapshot.threshold"), new Configuration.DeprecationDelta("dfs.datanode.dns.interface", "hdds.datanode.dns.interface"), new Configuration.DeprecationDelta("dfs.datanode.dns.nameserver", "hdds.datanode.dns.nameserver"), new Configuration.DeprecationDelta("dfs.datanode.hostname", "hdds.datanode.hostname"), new Configuration.DeprecationDelta("dfs.datanode.data.dir", "hdds.datanode.dir"), new Configuration.DeprecationDelta("dfs.datanode.use.datanode.hostname", "hdds.datanode.use.datanode.hostname"), new Configuration.DeprecationDelta("dfs.xframe.enabled", "hdds.xframe.enabled"), new Configuration.DeprecationDelta("dfs.xframe.value", "hdds.xframe.value"), new Configuration.DeprecationDelta("dfs.metrics.session-id", "hdds.metrics.session-id"), new Configuration.DeprecationDelta("dfs.client.https.keystore.resource", "ozone.https.client.keystore.resource"), new Configuration.DeprecationDelta("dfs.https.server.keystore.resource", "ozone.https.server.keystore.resource"), new Configuration.DeprecationDelta("dfs.http.policy", "ozone.http.policy"), new Configuration.DeprecationDelta("dfs.datanode.kerberos.principal", "hdds.datanode.kerberos.principal"), new Configuration.DeprecationDelta("dfs.datanode.kerberos.keytab.file", "hdds.datanode.kerberos.keytab.file"), new Configuration.DeprecationDelta("dfs.metrics.percentiles.intervals", "hdds.metrics.percentiles.intervals"), new Configuration.DeprecationDelta("hdds.recon.heartbeat.interval", "hdds.heartbeat.recon.interval")});
    }

    public int getInt(String name, String fallbackName, int defaultValue, Consumer<String> log) {
        String value = this.getTrimmed(name);
        if (value == null) {
            value = this.getTrimmed(fallbackName);
            if (log != null) {
                log.accept(name + " is not set.  Fallback to " + fallbackName + ", which is set to " + value);
            }
        }
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public synchronized void reloadConfiguration() {
        super.reloadConfiguration();
        this.delegatingProps = null;
    }

    protected final synchronized Properties getProps() {
        if (this.delegatingProps == null) {
            String complianceMode = this.getPropertyUnsafe("ozone.security.crypto.compliance.mode", "unrestricted");
            Properties cryptoProperties = this.getCryptoProperties();
            this.delegatingProps = new DelegatingProperties(super.getProps(), complianceMode, cryptoProperties);
        }
        return this.delegatingProps;
    }

    private String getPropertyUnsafe(String key, String defaultValue) {
        return super.getProps().getProperty(key, defaultValue);
    }

    private Properties getCryptoProperties() {
        try {
            return super.getAllPropertiesByTag(ConfigTag.CRYPTO_COMPLIANCE.toString());
        }
        catch (NoSuchMethodError e) {
            return new Properties();
        }
    }

    public long getOrFixDuration(Logger logger, String key, String defaultValue, TimeUnit unit) {
        this.maybeFixInvalidDuration(logger, key, defaultValue, unit);
        return this.getTimeDuration(key, defaultValue, unit);
    }

    private boolean maybeFixInvalidDuration(Logger logger, String key, String defaultValue, TimeUnit unit) {
        boolean fixed = this.maybeFixInvalidDuration(key, defaultValue, unit);
        if (fixed) {
            logger.warn("{} must be greater than zero, defaulting to {}", (Object)key, (Object)defaultValue);
        }
        return fixed;
    }

    private boolean maybeFixInvalidDuration(String key, String defaultValue, TimeUnit unit) {
        long duration = this.getTimeDuration(key, defaultValue, unit);
        if (duration <= 0L) {
            this.set(key, defaultValue);
            return true;
        }
        return false;
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        DelegatingProperties properties = (DelegatingProperties)this.getProps();
        return properties.iterator();
    }

    static {
        OzoneConfiguration.addDeprecatedKeys();
        OzoneConfiguration.activate();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="configuration")
    public static class XMLConfiguration {
        @XmlElement(name="property", type=Property.class)
        private List<Property> properties = new ArrayList<Property>();

        public XMLConfiguration() {
        }

        public XMLConfiguration(List<Property> properties) {
            this.properties = new ArrayList<Property>(properties);
        }

        public List<Property> getProperties() {
            return Collections.unmodifiableList(this.properties);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="property")
    public static class Property
    implements Comparable<Property> {
        private String name;
        private String value;
        private String tag;
        private String description;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public int compareTo(Property o) {
            if (this == o) {
                return 0;
            }
            return this.getName().compareTo(o.getName());
        }

        public String toString() {
            return this.getName() + " " + this.getValue() + " " + this.getTag();
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Property && ((Property)obj).getName().equals(this.getName());
        }
    }
}

