/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.snapshot;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.Handler;
import org.apache.hadoop.ozone.shell.ListPaginationOptions;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.bucket.BucketUri;
import picocli.CommandLine;

@CommandLine.Command(name="listDiff", aliases={"listDiffJob", "lsDiff", "lsDiffJob"}, description={"List snapshotDiff jobs for a bucket."})
public class ListSnapshotDiffHandler
extends Handler {
    @CommandLine.Mixin
    private BucketUri snapshotPath;
    @CommandLine.Option(names={"--job-status"}, description={"List jobs based on status.\nAccepted values are: queued, in_progress, done, failed, rejected"}, defaultValue="in_progress")
    private String jobStatus;
    @CommandLine.Option(names={"--all-status"}, description={"List all jobs regardless of status."}, defaultValue="false")
    private boolean listAllStatus;
    @CommandLine.Mixin
    private ListPaginationOptions listOptions;

    @Override
    protected OzoneAddress getAddress() {
        return this.snapshotPath.getValue();
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = this.snapshotPath.getValue().getVolumeName();
        String bucketName = this.snapshotPath.getValue().getBucketName();
        Iterator iterator = client.getObjectStore().listSnapshotDiffJobs(volumeName, bucketName, this.jobStatus, this.listAllStatus, this.listOptions.getStartItem());
        int counter = this.printAsJsonArray(iterator, this.listOptions.getLimit());
        if (this.isVerbose()) {
            System.out.printf("Found : %d snapshot diff jobs for o3://%s/ %s ", counter, volumeName, bucketName);
        }
    }
}

