/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.bucket;

import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import picocli.CommandLine;

public class BucketUri
implements CommandLine.ITypeConverter<OzoneAddress> {
    private static final String OZONE_BUCKET_URI_DESCRIPTION = "URI of the bucket (format: volume/bucket).\nOzone URI could either be a full URI or short URI.\nFull URI should start with o3://, in case of non-HA\nclusters it should be followed by the host name and\noptionally the port number. In case of HA clusters\nthe service id should be used. Service id provides a\nlogical name for multiple hosts and it is defined\nin the property ozone.om.service.ids.\nExample of a full URI with host name and port number\nfor a key:\no3://omhostname:9862/vol1/bucket1/key1\nWith a service id for a volume:\no3://omserviceid/vol1/\nShort URI should start from the volume.\nExample of a short URI for a bucket:\nvol1/bucket1\nAny unspecified information will be identified from\nthe config files.\n";
    @CommandLine.Parameters(index="0", arity="1..1", description={"URI of the bucket (format: volume/bucket).\nOzone URI could either be a full URI or short URI.\nFull URI should start with o3://, in case of non-HA\nclusters it should be followed by the host name and\noptionally the port number. In case of HA clusters\nthe service id should be used. Service id provides a\nlogical name for multiple hosts and it is defined\nin the property ozone.om.service.ids.\nExample of a full URI with host name and port number\nfor a key:\no3://omhostname:9862/vol1/bucket1/key1\nWith a service id for a volume:\no3://omserviceid/vol1/\nShort URI should start from the volume.\nExample of a short URI for a bucket:\nvol1/bucket1\nAny unspecified information will be identified from\nthe config files.\n"}, converter={BucketUri.class})
    private OzoneAddress value;

    public OzoneAddress getValue() {
        return this.value;
    }

    public OzoneAddress convert(String str) throws OzoneClientException {
        OzoneAddress address = new OzoneAddress(str);
        address.ensureBucketAddress();
        return address;
    }
}

