/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.checksum;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.List;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.ozone.client.checksum.AbstractBlockChecksumComputer;
import org.apache.hadoop.ozone.client.checksum.CrcComposer;
import org.apache.hadoop.ozone.client.checksum.CrcUtil;
import org.apache.hadoop.util.DataChecksum;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedBlockChecksumComputer
extends AbstractBlockChecksumComputer {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicatedBlockChecksumComputer.class);
    private final List<ContainerProtos.ChunkInfo> chunkInfoList;

    static MD5Hash digest(ByteBuffer data) {
        MessageDigest digester = MD5Hash.getDigester();
        digester.update(data);
        return new MD5Hash(digester.digest());
    }

    public ReplicatedBlockChecksumComputer(List<ContainerProtos.ChunkInfo> chunkInfoList) {
        this.chunkInfoList = chunkInfoList;
    }

    @Override
    public void compute(OzoneClientConfig.ChecksumCombineMode combineMode) throws IOException {
        switch (combineMode) {
            case MD5MD5CRC: {
                this.computeMd5Crc();
                return;
            }
            case COMPOSITE_CRC: {
                this.computeCompositeCrc();
                return;
            }
        }
        throw new IllegalArgumentException("unsupported combine mode");
    }

    private void computeMd5Crc() {
        ByteString bytes = ByteString.EMPTY;
        for (ContainerProtos.ChunkInfo chunkInfo : this.chunkInfoList) {
            ContainerProtos.ChecksumData checksumData = chunkInfo.getChecksumData();
            List checksums = checksumData.getChecksumsList();
            for (ByteString checksum : checksums) {
                bytes = bytes.concat(checksum);
            }
        }
        MD5Hash fileMD5 = ReplicatedBlockChecksumComputer.digest(bytes.asReadOnlyByteBuffer());
        this.setOutBytes(fileMD5.getDigest());
        LOG.debug("number of chunks={}, md5out={}", (Object)this.chunkInfoList.size(), (Object)fileMD5);
    }

    private void computeCompositeCrc() throws IOException {
        DataChecksum.Type dataChecksumType;
        Preconditions.checkArgument((!this.chunkInfoList.isEmpty() ? 1 : 0) != 0);
        ContainerProtos.ChunkInfo firstChunkInfo = this.chunkInfoList.get(0);
        switch (firstChunkInfo.getChecksumData().getType()) {
            case CRC32C: {
                dataChecksumType = DataChecksum.Type.CRC32C;
                break;
            }
            case CRC32: {
                dataChecksumType = DataChecksum.Type.CRC32;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported checksum type: " + firstChunkInfo.getChecksumData().getType());
            }
        }
        long chunkSize = firstChunkInfo.getLen();
        long bytesPerCrc = firstChunkInfo.getChecksumData().getBytesPerChecksum();
        CrcComposer blockCrcComposer = CrcComposer.newCrcComposer((DataChecksum.Type)dataChecksumType, (long)chunkSize);
        for (ContainerProtos.ChunkInfo chunkInfo : this.chunkInfoList) {
            ContainerProtos.ChecksumData checksumData = chunkInfo.getChecksumData();
            List checksums = checksumData.getChecksumsList();
            CrcComposer chunkCrcComposer = CrcComposer.newCrcComposer((DataChecksum.Type)dataChecksumType, (long)bytesPerCrc);
            long remainingChunkSize = chunkInfo.getLen();
            Preconditions.checkArgument((remainingChunkSize <= (long)checksums.size() * chunkSize ? 1 : 0) != 0);
            for (ByteString checksum : checksums) {
                int checksumDataCrc = checksum.asReadOnlyByteBuffer().getInt();
                chunkCrcComposer.update(checksumDataCrc, Math.min(bytesPerCrc, remainingChunkSize));
                remainingChunkSize -= bytesPerCrc;
            }
            int chunkChecksumCrc = CrcUtil.readInt((byte[])chunkCrcComposer.digest(), (int)0);
            blockCrcComposer.update(chunkChecksumCrc, chunkInfo.getLen());
        }
        byte[] compositeCrcChunkChecksum = blockCrcComposer.digest();
        this.setOutBytes(compositeCrcChunkChecksum);
        LOG.debug("number of chunks = {}, chunk checksum type is {}, composite checksum = {}", new Object[]{this.chunkInfoList.size(), dataChecksumType, compositeCrcChunkChecksum});
    }
}

