/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon.containergenerator;

import com.codahale.metrics.Timer;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.metadata.SCMDBDefinition;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.freon.containergenerator.BaseGenerator;
import picocli.CommandLine;

@CommandLine.Command(name="cgscm", description={"Offline container metadata generator for Storage Container Manager"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class GeneratorScm
extends BaseGenerator {
    private Table<ContainerID, ContainerInfo> containerStore;
    private Timer timer;

    @Override
    public Void call() throws Exception {
        this.init();
        OzoneConfiguration config = this.createOzoneConfiguration();
        DBStore scmDb = DBStoreBuilder.createDBStore((ConfigurationSource)config, (DBDefinition)SCMDBDefinition.get());
        this.containerStore = SCMDBDefinition.CONTAINERS.getTable(scmDb);
        this.timer = this.getMetrics().timer("scm-generator");
        this.runTests(this::writeScmData);
        scmDb.close();
        return null;
    }

    private void writeScmData(long index) throws Exception {
        this.timer.time(() -> {
            long containerId = this.getContainerIdOffset() + index;
            ContainerInfo containerInfo = new ContainerInfo.Builder().setContainerID(containerId).setState(HddsProtos.LifeCycleState.CLOSED).setReplicationConfig((ReplicationConfig)StandaloneReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE)).setOwner(GeneratorScm.getUserId()).build();
            this.containerStore.put((Object)ContainerID.valueOf((long)containerId), (Object)containerInfo);
            return null;
        });
    }
}

