/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.util.PayloadUtils;
import picocli.CommandLine;

@CommandLine.Command(name="om-echo", aliases={"ome"}, description={"Generate echo RPC request to the OM with or without payload. Max payload size is 2097151 KB"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class OmRPCLoadGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    private Timer timer;
    private OzoneManagerProtocolClientSideTranslatorPB[] clients;
    private byte[] payloadReqBytes = new byte[0];
    private int payloadRespSize;
    @CommandLine.Option(names={"--payload-req"}, description={"Specifies the size of payload in KB in RPC request. Max size is 2097151 KB"}, defaultValue="0")
    private int payloadReqSizeKB = 0;
    @CommandLine.Option(names={"--clients"}, description={"Number of clients, defaults 1."}, defaultValue="1")
    private int clientsCount = 1;
    @CommandLine.Option(names={"--payload-resp"}, description={"Specifies the size of payload in KB in RPC response. Max size is 2097151 KB"}, defaultValue="0")
    private int payloadRespSizeKB = 0;
    @CommandLine.Option(names={"--ratis"}, description={"Write to Ratis log, skip flag for read-only EchoRPC request"})
    private boolean writeToRatis = false;

    @Override
    public Void call() throws Exception {
        int i;
        Preconditions.checkArgument((this.payloadReqSizeKB >= 0 ? 1 : 0) != 0, (Object)"OM echo request payload size should be positive value or zero.");
        Preconditions.checkArgument((this.payloadRespSizeKB >= 0 ? 1 : 0) != 0, (Object)"OM echo response payload size should be positive value or zero.");
        OzoneConfiguration configuration = this.createOzoneConfiguration();
        this.clients = new OzoneManagerProtocolClientSideTranslatorPB[this.clientsCount];
        for (i = 0; i < this.clientsCount; ++i) {
            this.clients[i] = this.createOmClient(configuration, null);
        }
        this.init();
        this.payloadReqBytes = PayloadUtils.generatePayload((int)this.payloadSizeInBytes(this.payloadReqSizeKB));
        this.payloadRespSize = this.payloadSizeInBytes(this.payloadRespSizeKB);
        this.timer = this.getMetrics().timer("rpc-payload");
        try {
            this.runTests(this::sendRPCReq);
        }
        finally {
            for (i = 0; i < this.clientsCount; ++i) {
                if (this.clients[i] == null) continue;
                this.clients[i].close();
            }
        }
        return null;
    }

    private int payloadSizeInBytes(int payloadSizeKB) {
        return payloadSizeKB > 0 ? payloadSizeKB * 1024 : 0;
    }

    private void sendRPCReq(long l) throws Exception {
        this.timer.time(() -> {
            this.clients[(int)(l % (long)this.clientsCount)].echoRPCReq(this.payloadReqBytes, this.payloadRespSize, this.writeToRatis);
            return null;
        });
    }
}

