/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.snapshot;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.util.function.UncheckedAutoCloseableSupplier;

@CleanupTableInfo(cleanupTables={"snapshotInfoTable"})
public class OMSnapshotMoveTableKeysResponse
extends OMClientResponse {
    private long bucketId;
    private SnapshotInfo fromSnapshot;
    private SnapshotInfo nextSnapshot;
    private List<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> deletedKeys;
    private List<HddsProtos.KeyValue> renameKeysList;
    private List<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> deletedDirs;

    public OMSnapshotMoveTableKeysResponse(OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull SnapshotInfo fromSnapshot, SnapshotInfo nextSnapshot, long bucketId, List<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> deletedKeys, List<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> deletedDirs, List<HddsProtos.KeyValue> renamedKeys) {
        super(omResponse);
        this.fromSnapshot = fromSnapshot;
        this.nextSnapshot = nextSnapshot;
        this.deletedKeys = deletedKeys;
        this.renameKeysList = renamedKeys;
        this.deletedDirs = deletedDirs;
        this.bucketId = bucketId;
    }

    public OMSnapshotMoveTableKeysResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        OmSnapshotManager omSnapshotManager = ((OmMetadataManagerImpl)omMetadataManager).getOzoneManager().getOmSnapshotManager();
        Throwable throwable = null;
        Object var5_6 = null;
        try (UncheckedAutoCloseableSupplier<OmSnapshot> rcOmFromSnapshot = omSnapshotManager.getSnapshot(this.fromSnapshot.getSnapshotId());){
            Throwable throwable2;
            OmSnapshot fromOmSnapshot;
            block38: {
                fromOmSnapshot = (OmSnapshot)rcOmFromSnapshot.get();
                if (this.nextSnapshot != null) {
                    Throwable throwable3 = null;
                    throwable2 = null;
                    try (UncheckedAutoCloseableSupplier<OmSnapshot> rcOmNextSnapshot = omSnapshotManager.getSnapshot(this.nextSnapshot.getSnapshotId());){
                        OmSnapshot nextOmSnapshot = (OmSnapshot)rcOmNextSnapshot.get();
                        RDBStore nextSnapshotStore = (RDBStore)nextOmSnapshot.getMetadataManager().getStore();
                        Throwable throwable4 = null;
                        Object var14_21 = null;
                        try (BatchOperation writeBatch = nextSnapshotStore.initBatchOperation();){
                            this.addKeysToNextSnapshot(writeBatch, nextOmSnapshot.getMetadataManager());
                            nextSnapshotStore.commitBatchOperation(writeBatch);
                            nextSnapshotStore.getDb().flushWal(true);
                            nextSnapshotStore.getDb().flush();
                            break block38;
                        }
                        catch (Throwable throwable5) {
                            if (throwable4 == null) {
                                throwable4 = throwable5;
                            } else if (throwable4 != throwable5) {
                                throwable4.addSuppressed(throwable5);
                            }
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable3 == null) {
                            throwable3 = throwable6;
                        } else if (throwable3 != throwable6) {
                            throwable3.addSuppressed(throwable6);
                        }
                        throw throwable3;
                    }
                }
                this.addKeysToNextSnapshot(batchOperation, omMetadataManager);
            }
            RDBStore fromSnapshotStore = (RDBStore)fromOmSnapshot.getMetadataManager().getStore();
            throwable2 = null;
            Object var10_15 = null;
            try (BatchOperation fromSnapshotBatchOp = fromSnapshotStore.initBatchOperation();){
                this.deleteKeysFromSnapshot(fromSnapshotBatchOp, fromOmSnapshot.getMetadataManager());
                fromSnapshotStore.commitBatchOperation(fromSnapshotBatchOp);
                fromSnapshotStore.getDb().flushWal(true);
                fromSnapshotStore.getDb().flush();
            }
            catch (Throwable throwable7) {
                if (throwable2 == null) {
                    throwable2 = throwable7;
                } else if (throwable2 != throwable7) {
                    throwable2.addSuppressed(throwable7);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable8) {
            if (throwable == null) {
                throwable = throwable8;
            } else if (throwable != throwable8) {
                throwable.addSuppressed(throwable8);
            }
            throw throwable;
        }
        omMetadataManager.getSnapshotInfoTable().putWithBatch(batchOperation, (Object)this.fromSnapshot.getTableKey(), (Object)this.fromSnapshot);
        if (this.nextSnapshot != null) {
            omMetadataManager.getSnapshotInfoTable().putWithBatch(batchOperation, (Object)this.nextSnapshot.getTableKey(), (Object)this.nextSnapshot);
        }
    }

    private void deleteKeysFromSnapshot(BatchOperation batchOp, OMMetadataManager fromSnapshotMetadataManager) throws IOException {
        for (OzoneManagerProtocolProtos.SnapshotMoveKeyInfos deletedOmKeyInfo : this.deletedKeys) {
            fromSnapshotMetadataManager.getDeletedTable().deleteWithBatch(batchOp, (Object)deletedOmKeyInfo.getKey());
        }
        for (HddsProtos.KeyValue renameEntry : this.renameKeysList) {
            fromSnapshotMetadataManager.getSnapshotRenamedTable().deleteWithBatch(batchOp, (Object)renameEntry.getKey());
        }
        for (OzoneManagerProtocolProtos.SnapshotMoveKeyInfos deletedDirInfo : this.deletedDirs) {
            fromSnapshotMetadataManager.getDeletedDirTable().deleteWithBatch(batchOp, (Object)deletedDirInfo.getKey());
        }
    }

    private void addKeysToNextSnapshot(BatchOperation batchOp, OMMetadataManager metadataManager) throws IOException {
        for (HddsProtos.KeyValue renameEntry : this.renameKeysList) {
            metadataManager.getSnapshotRenamedTable().putWithBatch(batchOp, (Object)renameEntry.getKey(), (Object)renameEntry.getValue());
        }
        for (OzoneManagerProtocolProtos.SnapshotMoveKeyInfos deletedKeyInfo : this.deletedKeys) {
            RepeatedOmKeyInfo omKeyInfos = SnapshotUtils.createMergedRepeatedOmKeyInfoFromDeletedTableEntry(deletedKeyInfo, this.bucketId, metadataManager);
            metadataManager.getDeletedTable().putWithBatch(batchOp, (Object)deletedKeyInfo.getKey(), (Object)omKeyInfos);
        }
        for (OzoneManagerProtocolProtos.SnapshotMoveKeyInfos deletedDirInfo : this.deletedDirs) {
            metadataManager.getDeletedDirTable().putWithBatch(batchOp, (Object)deletedDirInfo.getKey(), (Object)OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)((OzoneManagerProtocolProtos.KeyInfo)deletedDirInfo.getKeyInfosList().get(0))));
        }
    }
}

