/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.tenant;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OMMultiTenantManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.OmDBTenantState;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.tenant.OMTenantCreateResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.DisallowedUntilLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMTenantCreateRequest
extends OMVolumeRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMTenantCreateRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMTenantCreateRequest.class);
    }

    public OMTenantCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.MULTITENANCY_SCHEMA)
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        boolean forceCreationWhenVolumeExists;
        OzoneManager ozoneManager2 = ozoneManager;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(joinPoint);
        }
        OMMultiTenantManager multiTenantManager = ozoneManager.getMultiTenantManager();
        multiTenantManager.checkAdmin();
        OzoneManagerProtocolProtos.OMRequest omRequest = super.preExecute(ozoneManager);
        OzoneManagerProtocolProtos.CreateTenantRequest request = omRequest.getCreateTenantRequest();
        Preconditions.checkNotNull((Object)request);
        String tenantId = request.getTenantId();
        if (tenantId.contains("$")) {
            throw new OMException("Invalid tenant name " + tenantId + ". Tenant name should not contain delimiter.", OMException.ResultCodes.INVALID_VOLUME_NAME);
        }
        if (ozoneManager.getMetadataManager().getTenantStateTable().isExist((Object)tenantId)) {
            LOG.debug("tenant: {} already exists", (Object)tenantId);
            throw new OMException("Tenant '" + tenantId + "' already exists", OMException.ResultCodes.TENANT_ALREADY_EXISTS);
        }
        String owner = this.getUserName();
        String volumeName = request.getVolumeName();
        OmUtils.validateVolumeName((String)volumeName, (boolean)ozoneManager.isStrictS3());
        String dbVolumeKey = ozoneManager.getMetadataManager().getVolumeKey(volumeName);
        boolean bl = forceCreationWhenVolumeExists = request.hasForceCreationWhenVolumeExists() && request.getForceCreationWhenVolumeExists();
        if (!forceCreationWhenVolumeExists && ozoneManager.getMetadataManager().getVolumeTable().isExist((Object)dbVolumeKey)) {
            LOG.debug("volume: '{}' already exists", (Object)volumeName);
            throw new OMException("Volume already exists", OMException.ResultCodes.VOLUME_ALREADY_EXISTS);
        }
        OzoneManagerProtocolProtos.VolumeInfo volumeInfo = OzoneManagerProtocolProtos.VolumeInfo.newBuilder().setVolume(volumeName).setAdminName(owner).setOwnerName(owner).build();
        long initialTime = Time.now();
        OzoneManagerProtocolProtos.VolumeInfo updatedVolumeInfo = volumeInfo.toBuilder().setCreationTime(initialTime).setModificationTime(initialTime).build();
        String userRoleName = OMMultiTenantManager.getDefaultUserRoleName(tenantId);
        String adminRoleName = OMMultiTenantManager.getDefaultAdminRoleName(tenantId);
        multiTenantManager.getAuthorizerLock().tryWriteLockInOMRequest();
        try {
            multiTenantManager.getAuthorizerOp().createTenant(tenantId, userRoleName, adminRoleName);
        }
        catch (Exception e) {
            multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
            throw e;
        }
        OzoneManagerProtocolProtos.OMRequest.Builder omRequestBuilder = omRequest.toBuilder().setCreateTenantRequest(OzoneManagerProtocolProtos.CreateTenantRequest.newBuilder().setTenantId(tenantId).setVolumeName(volumeName).setUserRoleName(userRoleName).setAdminRoleName(adminRoleName).setForceCreationWhenVolumeExists(forceCreationWhenVolumeExists)).setCreateVolumeRequest(OzoneManagerProtocolProtos.CreateVolumeRequest.newBuilder().setVolumeInfo(updatedVolumeInfo));
        return omRequestBuilder.build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        Exception exception;
        String volumeName;
        String tenantId;
        Map<String, String> auditMap;
        OMTenantCreateResponse omClientResponse;
        OMMetrics omMetrics;
        block23: {
            long transactionLogIndex = context.getIndex();
            OMMultiTenantManager multiTenantManager = ozoneManager.getMultiTenantManager();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumTenantCreates();
            omMetrics.incNumVolumeCreates();
            omClientResponse = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            OmVolumeArgs omVolumeArgs = null;
            boolean acquiredVolumeLock = false;
            boolean acquiredUserLock = false;
            String owner = this.getOmRequest().getUserInfo().getUserName();
            auditMap = new HashMap<String, String>();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            OzoneManagerProtocolProtos.CreateTenantRequest request = this.getOmRequest().getCreateTenantRequest();
            tenantId = request.getTenantId();
            String userRoleName = request.getUserRoleName();
            String adminRoleName = request.getAdminRoleName();
            boolean forceCreationWhenVolumeExists = request.getForceCreationWhenVolumeExists();
            OzoneManagerProtocolProtos.VolumeInfo volumeInfo = this.getOmRequest().getCreateVolumeRequest().getVolumeInfo();
            volumeName = volumeInfo.getVolume();
            Preconditions.checkNotNull((Object)volumeName);
            Preconditions.checkState((boolean)request.getVolumeName().equals(volumeName), (Object)"CreateTenantRequest's volumeName value should match VolumeInfo's");
            String dbVolumeKey = omMetadataManager.getVolumeKey(volumeName);
            exception = null;
            try {
                try {
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.CREATE, tenantId, null, null);
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volumeName}));
                    acquiredVolumeLock = this.getOmLockDetails().isLockAcquired();
                    boolean skipVolumeCreation = false;
                    if (omMetadataManager.getVolumeTable().isExist((Object)dbVolumeKey)) {
                        LOG.debug("volume: '{}' already exists", (Object)volumeName);
                        if (forceCreationWhenVolumeExists) {
                            LOG.warn("forceCreationWhenVolumeExists = true. Resuming tenant creation despite volume '{}' existence", (Object)volumeName);
                            skipVolumeCreation = true;
                        } else {
                            throw new OMException("Volume already exists", OMException.ResultCodes.VOLUME_ALREADY_EXISTS);
                        }
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.USER_LOCK, new String[]{owner}));
                    acquiredUserLock = this.getOmLockDetails().isLockAcquired();
                    OzoneManagerStorageProtos.PersistedUserVolumeInfo volumeList = null;
                    if (!skipVolumeCreation) {
                        omVolumeArgs = OmVolumeArgs.getFromProtobuf((OzoneManagerProtocolProtos.VolumeInfo)volumeInfo);
                        omVolumeArgs.setQuotaInBytes(-1L);
                        omVolumeArgs.setQuotaInNamespace(-1L);
                        omVolumeArgs.setObjectID(ozoneManager.getObjectIdFromTxId(transactionLogIndex));
                        omVolumeArgs.setUpdateID(transactionLogIndex);
                        omVolumeArgs.incRefCount();
                        Preconditions.checkState((omVolumeArgs.getRefCount() == 1L ? 1 : 0) != 0, (Object)"refCount should have been set to 1");
                        String dbUserKey = omMetadataManager.getUserKey(owner);
                        volumeList = (OzoneManagerStorageProtos.PersistedUserVolumeInfo)omMetadataManager.getUserTable().get((Object)dbUserKey);
                        volumeList = OMTenantCreateRequest.addVolumeToOwnerList(volumeList, volumeName, owner, ozoneManager.getMaxUserVolumeCount(), transactionLogIndex);
                        OMTenantCreateRequest.createVolume(omMetadataManager, omVolumeArgs, volumeList, dbVolumeKey, dbUserKey, transactionLogIndex);
                        LOG.debug("volume: '{}' successfully created", (Object)dbVolumeKey);
                    } else {
                        LOG.info("Skipped volume '{}' creation. Will only increment volume refCount", (Object)volumeName);
                        omVolumeArgs = this.getVolumeInfo(omMetadataManager, volumeName);
                        omVolumeArgs.incRefCount();
                        Preconditions.checkState((omVolumeArgs.getRefCount() == 1L ? 1 : 0) != 0, (Object)"refCount should have been set to 1");
                        omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getVolumeKey(volumeName)), CacheValue.get((long)transactionLogIndex, (Object)omVolumeArgs));
                    }
                    auditMap = omVolumeArgs.toAuditMap();
                    if (omMetadataManager.getTenantStateTable().isExist((Object)tenantId)) {
                        LOG.debug("tenant: '{}' already exists", (Object)tenantId);
                        throw new OMException("Tenant already exists", OMException.ResultCodes.TENANT_ALREADY_EXISTS);
                    }
                    String bucketNamespaceName = volumeName;
                    String bucketNamespacePolicyName = OMMultiTenantManager.getDefaultBucketNamespacePolicyName(tenantId);
                    String bucketPolicyName = OMMultiTenantManager.getDefaultBucketPolicyName(tenantId);
                    OmDBTenantState omDBTenantState = new OmDBTenantState(tenantId, bucketNamespaceName, userRoleName, adminRoleName, bucketNamespacePolicyName, bucketPolicyName);
                    omMetadataManager.getTenantStateTable().addCacheEntry(new CacheKey((Object)tenantId), CacheValue.get((long)transactionLogIndex, (Object)omDBTenantState));
                    multiTenantManager.getCacheOp().createTenant(tenantId, userRoleName, adminRoleName);
                    omResponse.setCreateTenantResponse(OzoneManagerProtocolProtos.CreateTenantResponse.newBuilder().build());
                    omClientResponse = new OMTenantCreateResponse(omResponse.build(), omVolumeArgs, volumeList, omDBTenantState);
                }
                catch (IOException | InvalidPathException ex) {
                    exception = ex;
                    omClientResponse = new OMTenantCreateResponse(this.createErrorOMResponse(omResponse, exception));
                    if (acquiredUserLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.USER_LOCK, new String[]{owner}));
                    }
                    if (acquiredVolumeLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volumeName}));
                    }
                    multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (acquiredUserLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.USER_LOCK, new String[]{owner}));
                }
                if (acquiredVolumeLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volumeName}));
                }
                multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredUserLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.USER_LOCK, new String[]{owner}));
            }
            if (acquiredVolumeLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volumeName}));
            }
            multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        auditMap.put("tenant", tenantId);
        this.markForAudit(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.CREATE_TENANT, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            LOG.info("Created tenant '{}' and volume '{}'", (Object)tenantId, (Object)volumeName);
            omMetrics.incNumTenants();
            omMetrics.incNumVolumes();
        } else {
            LOG.error("Failed to create tenant '{}'", (Object)tenantId, (Object)exception);
            omMetrics.incNumTenantCreateFails();
        }
        return omClientResponse;
    }

    public String getUserName() throws IOException {
        UserGroupInformation ugi = ProtobufRpcEngine.Server.getRemoteUser();
        if (ugi != null) {
            return ugi.getShortUserName();
        }
        throw new OMException("User name is null.", OMException.ResultCodes.USER_NOT_FOUND);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMTenantCreateRequest.java", OMTenantCreateRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.tenant.OMTenantCreateRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 107);
    }
}

