/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hdds.utils.CollectionUtils;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.TypedTable;
import org.apache.hadoop.hdds.utils.db.cache.TableCache;
import org.apache.hadoop.hdds.utils.db.managed.ManagedColumnFamilyOptions;
import org.apache.ratis.util.JavaUtils;

public class DBColumnFamilyDefinition<KEY, VALUE> {
    private final String tableName;
    private final Codec<KEY> keyCodec;
    private final Codec<VALUE> valueCodec;
    private final String name;
    private volatile ManagedColumnFamilyOptions cfOptions;

    public DBColumnFamilyDefinition(String tableName, Codec<KEY> keyCodec, Codec<VALUE> valueCodec) {
        this.tableName = Objects.requireNonNull(tableName, "tableName == null");
        this.keyCodec = Objects.requireNonNull(keyCodec, "keyCodec == null");
        this.valueCodec = Objects.requireNonNull(valueCodec, "valueCodec == null");
        this.name = tableName + "-def: " + JavaUtils.getClassSimpleName(this.getKeyType()) + " -> " + JavaUtils.getClassSimpleName(this.getValueType());
        this.cfOptions = null;
    }

    public static Map<String, DBColumnFamilyDefinition<?, ?>> newUnmodifiableMap(DBColumnFamilyDefinition<?, ?> ... families) {
        return DBColumnFamilyDefinition.newUnmodifiableMap(Collections.emptyMap(), families);
    }

    public static Map<String, DBColumnFamilyDefinition<?, ?>> newUnmodifiableMap(Map<String, DBColumnFamilyDefinition<?, ?>> existing, DBColumnFamilyDefinition<?, ?> ... families) {
        return CollectionUtils.newUnmodifiableMap(Arrays.asList(families), DBColumnFamilyDefinition::getName, existing);
    }

    public static Map<String, List<DBColumnFamilyDefinition<?, ?>>> newUnmodifiableMultiMap(DBColumnFamilyDefinition<?, ?> ... families) {
        return CollectionUtils.newUnmodifiableMultiMap(Arrays.asList(families), DBColumnFamilyDefinition::getName);
    }

    public TypedTable<KEY, VALUE> getTable(DBStore db) throws RocksDatabaseException, CodecException {
        return db.getTable(this.tableName, this.keyCodec, this.valueCodec);
    }

    public TypedTable<KEY, VALUE> getTable(DBStore db, TableCache.CacheType cacheType) throws RocksDatabaseException, CodecException {
        return db.getTable(this.tableName, this.keyCodec, this.valueCodec, cacheType);
    }

    public String getName() {
        return this.tableName;
    }

    public Class<KEY> getKeyType() {
        return this.keyCodec.getTypeClass();
    }

    public Codec<KEY> getKeyCodec() {
        return this.keyCodec;
    }

    public Class<VALUE> getValueType() {
        return this.valueCodec.getTypeClass();
    }

    public Codec<VALUE> getValueCodec() {
        return this.valueCodec;
    }

    public ManagedColumnFamilyOptions getCfOptions() {
        return this.cfOptions;
    }

    public void setCfOptions(ManagedColumnFamilyOptions cfOptions) {
        this.cfOptions = cfOptions;
    }

    public String toString() {
        return this.name;
    }
}

