/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server.http;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.hadoop.hdds.utils.PrometheusMetricsSinkUtil;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricType;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsTag;

public class PrometheusMetricsSink
implements MetricsSink {
    private Map<String, Map<String, String>> metricLines = Collections.synchronizedSortedMap(new TreeMap());
    private Map<String, Map<String, String>> nextMetricLines = Collections.synchronizedSortedMap(new TreeMap());
    private final String servername;

    public PrometheusMetricsSink(String servername) {
        this.servername = servername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMetrics(MetricsRecord metricsRecord) {
        for (AbstractMetric metric : metricsRecord.metrics()) {
            if (metric.type() != MetricType.COUNTER && metric.type() != MetricType.GAUGE) continue;
            String metricName = PrometheusMetricsSinkUtil.getMetricName(metricsRecord.name(), metric.name());
            String username = PrometheusMetricsSinkUtil.getUsername(metricsRecord.name(), metric.name());
            String key = PrometheusMetricsSinkUtil.prometheusName(metricsRecord.name(), metricName);
            String prometheusMetricKeyAsString = this.getPrometheusMetricKeyAsString(metricsRecord, key, username);
            String metricKey = "# TYPE " + key + " " + metric.type().toString().toLowerCase();
            PrometheusMetricsSink prometheusMetricsSink = this;
            synchronized (prometheusMetricsSink) {
                this.nextMetricLines.computeIfAbsent(metricKey, any -> Collections.synchronizedSortedMap(new TreeMap())).put(prometheusMetricKeyAsString, String.valueOf(metric.value()));
            }
        }
    }

    private String getPrometheusMetricKeyAsString(MetricsRecord metricsRecord, String key, String username) {
        StringBuilder prometheusMetricKey = new StringBuilder();
        prometheusMetricKey.append(key).append('{');
        String sep = "";
        List<MetricsTag> metricsTags = PrometheusMetricsSinkUtil.addTags(key, username, this.servername, metricsRecord.tags());
        for (MetricsTag tag : metricsTags) {
            String tagName = tag.name().toLowerCase();
            if (tagName.equals("numopenconnectionsperuser")) continue;
            prometheusMetricKey.append(sep).append(tagName).append("=\"").append(tag.value()).append('\"');
            sep = ",";
        }
        prometheusMetricKey.append('}');
        return prometheusMetricKey.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PrometheusMetricsSink prometheusMetricsSink = this;
        synchronized (prometheusMetricsSink) {
            this.metricLines = this.nextMetricLines;
            this.nextMetricLines = Collections.synchronizedSortedMap(new TreeMap());
        }
    }

    public void init(SubsetConfiguration subsetConfiguration) {
    }

    public synchronized void writeMetrics(Writer writer) throws IOException {
        for (Map.Entry<String, Map<String, String>> metricsEntry : this.metricLines.entrySet()) {
            writer.write(metricsEntry.getKey() + "\n");
            for (Map.Entry<String, String> metrics : metricsEntry.getValue().entrySet()) {
                writer.write(metrics.getKey() + " " + metrics.getValue() + "\n");
            }
        }
    }
}

