/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.fs.AbstractSpaceUsageSource;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DU
extends AbstractSpaceUsageSource {
    private static final Logger LOG = LoggerFactory.getLogger(DU.class);
    private final DUShell duShell;
    private final String[] command;
    private final String commandString;
    private final Supplier<File> exclusionProvider;

    public DU(File path) {
        this(path, null);
    }

    public DU(File path, String excludePattern) {
        super(path);
        this.command = DU.constructCommand(this.getPath(), excludePattern);
        this.commandString = String.join((CharSequence)" ", this.command);
        this.duShell = new DUShell();
        this.exclusionProvider = null;
    }

    public DU(Supplier<File> exclusionProvider, File path) {
        super(path);
        this.exclusionProvider = exclusionProvider;
        this.duShell = new DUShell();
        this.command = null;
        this.commandString = null;
    }

    public long getUsedSpace() {
        return DU.time(this.duShell::getUsed, LOG);
    }

    private static String[] constructCommand(String path, String excludePattern) {
        LinkedList<String> parts = new LinkedList<String>();
        parts.add("du");
        parts.add("-sk");
        if (excludePattern != null) {
            if (Shell.MAC) {
                parts.add("-I");
            } else {
                parts.add("--exclude");
            }
            parts.add(excludePattern);
        }
        parts.add(path);
        return parts.toArray(new String[0]);
    }

    public static void main(String[] args) {
        String path = ".";
        if (args.length > 0) {
            path = args[0];
        }
        DU du = new DU(new File(path));
        du.duShell.getUsed();
        System.out.println((Object)du.duShell);
    }

    private final class DUShell
    extends Shell {
        private final AtomicLong value = new AtomicLong();

        private DUShell() {
        }

        public long getUsed() {
            try {
                super.run();
                return this.value.get();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public String toString() {
            if (DU.this.exclusionProvider != null) {
                return String.join((CharSequence)" ", this.getExecString()) + "\n" + this.value.get() + "\t" + DU.this.getPath();
            }
            return DU.this.commandString + "\n" + this.value.get() + "\t" + DU.this.getPath();
        }

        protected String[] getExecString() {
            if (DU.this.exclusionProvider != null) {
                File exclusionFile = (File)DU.this.exclusionProvider.get();
                if (null == exclusionFile) {
                    return DU.constructCommand(DU.this.getPath(), null);
                }
                return DU.constructCommand(DU.this.getPath(), exclusionFile.getAbsolutePath());
            }
            return DU.this.command;
        }

        protected void parseExecResult(BufferedReader lines) throws IOException {
            String line = lines.readLine();
            if (line == null) {
                throw new IOException("Expecting a line not the end of stream");
            }
            String[] tokens = line.split("\t");
            if (tokens.length == 0) {
                throw new IOException("Illegal du output");
            }
            long kilobytes = Long.parseLong(tokens[0]);
            this.value.set(kilobytes * 1024L);
        }
    }
}

