/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.ozone.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibraryLoader {
    private static final Logger LOG = LoggerFactory.getLogger(NativeLibraryLoader.class);
    public static final int LIBRARY_SHUTDOWN_HOOK_PRIORITY = 1;
    private static final String OS = System.getProperty("os.name").toLowerCase();
    public static final String NATIVE_LIB_TMP_DIR = "native.lib.tmp.dir";
    private Map<String, Boolean> librariesLoaded;
    private static volatile NativeLibraryLoader instance;

    public NativeLibraryLoader(Map<String, Boolean> librariesLoaded) {
        this.librariesLoaded = librariesLoaded;
    }

    private static synchronized void initNewInstance() {
        if (instance == null) {
            instance = new NativeLibraryLoader(new ConcurrentHashMap<String, Boolean>());
        }
    }

    public static NativeLibraryLoader getInstance() {
        if (instance == null) {
            NativeLibraryLoader.initNewInstance();
        }
        return instance;
    }

    public static String getJniLibraryFileName() {
        return NativeLibraryLoader.appendLibOsSuffix("libozone_rocksdb_tools");
    }

    public static String getJniLibraryFileName(String libraryName) {
        return NativeLibraryLoader.appendLibOsSuffix("lib" + libraryName);
    }

    public static boolean isMac() {
        return OS.startsWith("mac");
    }

    public static boolean isWindows() {
        return OS.startsWith("win");
    }

    public static boolean isLinux() {
        return OS.startsWith("linux");
    }

    @VisibleForTesting
    static String getLibOsSuffix() {
        if (NativeLibraryLoader.isMac()) {
            return ".dylib";
        }
        if (NativeLibraryLoader.isWindows()) {
            return ".dll";
        }
        if (NativeLibraryLoader.isLinux()) {
            return ".so";
        }
        throw new UnsatisfiedLinkError(String.format("Unsupported OS %s", OS));
    }

    private static String appendLibOsSuffix(String libraryFileName) {
        return libraryFileName + NativeLibraryLoader.getLibOsSuffix();
    }

    public static boolean isLibraryLoaded() {
        return NativeLibraryLoader.isLibraryLoaded("ozone_rocksdb_tools");
    }

    public static boolean isLibraryLoaded(String libraryName) {
        return NativeLibraryLoader.getInstance().librariesLoaded.getOrDefault(libraryName, false);
    }

    public synchronized boolean loadLibrary(String libraryName, List<String> dependentFiles) {
        if (NativeLibraryLoader.isLibraryLoaded(libraryName)) {
            return true;
        }
        LOG.info("Loading Library: {}", (Object)libraryName);
        boolean loaded = false;
        try {
            Pair<Optional<File>, List<File>> files;
            loaded = false;
            try {
                System.loadLibrary(libraryName);
                loaded = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!loaded && ((Optional)(files = this.copyResourceFromJarToTemp(libraryName, dependentFiles)).getKey()).isPresent()) {
                System.load(((File)((Optional)files.getKey()).get()).getAbsolutePath());
                loaded = true;
            }
        }
        catch (Throwable e) {
            LOG.warn("Unable to load library: {}", (Object)libraryName, (Object)e);
        }
        this.librariesLoaded.put(libraryName, loaded);
        return NativeLibraryLoader.isLibraryLoaded(libraryName);
    }

    @VisibleForTesting
    static String getSystemProperty(String property) {
        return System.getProperty(property);
    }

    @VisibleForTesting
    static InputStream getResourceStream(String libraryFileName) throws IOException {
        return NativeLibraryLoader.class.getClassLoader().getResourceAsStream(libraryFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Optional<File>, List<File>> copyResourceFromJarToTemp(String libraryName, List<String> dependentFileNames) throws IOException {
        String libraryFileName = NativeLibraryLoader.getJniLibraryFileName(libraryName);
        try (InputStream is = null;){
            is = NativeLibraryLoader.getResourceStream(libraryFileName);
            if (is == null) {
                Pair pair = Pair.of(Optional.empty(), null);
                return pair;
            }
            String nativeLibDir = Objects.nonNull(NativeLibraryLoader.getSystemProperty(NATIVE_LIB_TMP_DIR)) ? NativeLibraryLoader.getSystemProperty(NATIVE_LIB_TMP_DIR) : "";
            File dir = new File(nativeLibDir).getAbsoluteFile();
            Path tempPath = Files.createTempDirectory(dir.toPath(), libraryName, new FileAttribute[0]);
            File tempDir = tempPath.toFile();
            if (!tempDir.exists()) {
                Pair pair = Pair.of(Optional.empty(), null);
                return pair;
            }
            Path libPath = tempPath.resolve(libraryFileName);
            Files.copy(is, libPath, StandardCopyOption.REPLACE_EXISTING);
            File libFile = libPath.toFile();
            if (libFile.exists()) {
                libFile.deleteOnExit();
            }
            ArrayList<File> dependentFiles = new ArrayList<File>();
            for (String fileName : dependentFileNames) {
                if (is != null) {
                    is.close();
                }
                is = NativeLibraryLoader.getResourceStream(fileName);
                Path path = tempPath.resolve(fileName);
                Files.copy(is, path, StandardCopyOption.REPLACE_EXISTING);
                File file = path.toFile();
                if (file.exists()) {
                    file.deleteOnExit();
                }
                dependentFiles.add(file);
            }
            ShutdownHookManager.get().addShutdownHook(() -> FileUtils.deleteQuietly((File)tempDir), 1);
            Pair pair = Pair.of(Optional.of(libFile), dependentFiles);
            return pair;
        }
    }
}

