/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.ozoneimpl.AbstractContainerScannerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBackgroundContainerScanner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBackgroundContainerScanner.class);
    private final long dataScanInterval;
    private final Thread scannerThread;
    private final AtomicBoolean stopping;
    private final AtomicBoolean pausing = new AtomicBoolean();

    public AbstractBackgroundContainerScanner(String name, long dataScanInterval) {
        this.dataScanInterval = dataScanInterval;
        this.stopping = new AtomicBoolean(false);
        this.scannerThread = new Thread((Runnable)this, name);
        this.scannerThread.setDaemon(true);
    }

    public void start() {
        this.scannerThread.start();
    }

    @Override
    public final void run() {
        AbstractContainerScannerMetrics metrics = this.getMetrics();
        try {
            while (!this.stopping.get()) {
                this.runIteration();
                metrics.resetNumContainersScanned();
                metrics.resetNumUnhealthyContainers();
            }
            LOG.info("{} exiting.", (Object)this);
        }
        catch (Exception e) {
            LOG.error("{} exiting because of exception ", (Object)this, (Object)e);
        }
        finally {
            if (metrics != null) {
                metrics.unregister();
            }
        }
    }

    @VisibleForTesting
    public final void runIteration() {
        boolean paused = this.pausing.get();
        long startTime = System.nanoTime();
        if (!paused) {
            this.scanContainers();
        }
        long totalDuration = System.nanoTime() - startTime;
        if (this.stopping.get()) {
            return;
        }
        if (paused) {
            LOG.debug("Skipped iteration due to pause");
        } else {
            AbstractContainerScannerMetrics metrics = this.getMetrics();
            metrics.incNumScanIterations();
            LOG.info("Completed an iteration in {} minutes. Number of iterations (since the data-node restart) : {}, Number of containers scanned in this iteration : {}, Number of unhealthy containers found in this iteration : {}", new Object[]{TimeUnit.NANOSECONDS.toMinutes(totalDuration), metrics.getNumScanIterations(), metrics.getNumContainersScanned(), metrics.getNumUnHealthyContainers()});
        }
        long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(totalDuration);
        long remainingSleep = this.dataScanInterval - elapsedMillis;
        this.handleRemainingSleep(remainingSleep);
    }

    private void scanContainers() {
        Iterator<Container<?>> itr = this.getContainerIterator();
        while (itr.hasNext()) {
            boolean stopped = this.stopping.get();
            boolean paused = this.pausing.get();
            if (stopped || paused) {
                LOG.info("{} exits scan loop stop={} pause={}", new Object[]{this, stopped, paused});
                break;
            }
            Container<?> c = itr.next();
            try {
                this.scanContainer(c);
            }
            catch (InterruptedException ex) {
                this.stopping.set(true);
            }
            catch (IOException ex) {
                LOG.warn("Unexpected exception while scanning container " + ((ContainerData)c.getContainerData()).getContainerID(), (Throwable)ex);
            }
        }
    }

    public abstract Iterator<Container<?>> getContainerIterator();

    public abstract void scanContainer(Container<?> var1) throws IOException, InterruptedException;

    public final void handleRemainingSleep(long remainingSleep) {
        if (remainingSleep > 0L) {
            try {
                Thread.sleep(remainingSleep);
            }
            catch (InterruptedException ignored) {
                this.stopping.set(true);
                LOG.warn("Background container scan was interrupted.");
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void shutdown() {
        if (this.stopping.compareAndSet(false, true)) {
            this.scannerThread.interrupt();
            try {
                this.scannerThread.join();
            }
            catch (InterruptedException ex) {
                LOG.warn("Unexpected exception while stopping data scanner.", (Throwable)ex);
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isAlive() {
        return this.scannerThread.isAlive();
    }

    public void pause() {
        this.pausing.getAndSet(true);
    }

    public void unpause() {
        this.pausing.getAndSet(false);
    }

    @VisibleForTesting
    public abstract AbstractContainerScannerMetrics getMetrics();
}

