/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collection;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.GrantOnStep;
import org.jooq.GrantToStep;
import org.jooq.GrantWithGrantOptionStep;
import org.jooq.Name;
import org.jooq.Privilege;
import org.jooq.Role;
import org.jooq.Table;
import org.jooq.User;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;

final class GrantImpl
extends AbstractQuery
implements GrantOnStep,
GrantToStep,
GrantWithGrantOptionStep {
    private static final long serialVersionUID = -6509384254822040545L;
    private static final Clause[] CLAUSE = new Clause[]{Clause.GRANT};
    private final Collection<? extends Privilege> privileges;
    private Role role;
    private Table<?> table;
    private User user;
    private boolean withGrantOption;

    GrantImpl(Configuration configuration, Collection<? extends Privilege> privileges) {
        super(configuration);
        this.privileges = privileges;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.start(Clause.GRANT_PRIVILEGE).visit(Keywords.K_GRANT).sql(' ');
        String separator = "";
        for (Privilege privilege : this.privileges) {
            ctx.sql(separator).visit(privilege);
            separator = ", ";
        }
        ctx.end(Clause.GRANT_PRIVILEGE).sql(' ').start(Clause.GRANT_ON).visit(Keywords.K_ON).sql(' ').visit(this.table).end(Clause.GRANT_ON).sql(' ').start(Clause.GRANT_TO).visit(Keywords.K_TO).sql(' ');
        if (this.user != null) {
            ctx.visit(this.user);
        } else if (this.role != null) {
            ctx.visit(this.role);
        } else {
            ctx.visit(Keywords.K_PUBLIC);
        }
        if (this.withGrantOption) {
            ctx.sql(' ').visit(Keywords.K_WITH_GRANT_OPTION);
        }
        ctx.end(Clause.GRANT_TO);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSE;
    }

    @Override
    public final GrantImpl on(Table<?> t) {
        this.table = t;
        return this;
    }

    @Override
    public final GrantImpl on(Name t) {
        return this.on((Table)DSL.table(t));
    }

    @Override
    public final GrantImpl on(String t) {
        return this.on((Table)DSL.table(t));
    }

    @Override
    public final GrantImpl to(User u) {
        this.user = u;
        return this;
    }

    @Override
    public final GrantImpl to(Role r) {
        this.role = r;
        return this;
    }

    @Override
    public final GrantImpl toPublic() {
        return this;
    }

    @Override
    public final GrantImpl withGrantOption() {
        this.withGrantOption = true;
        return this;
    }
}

