/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.om;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.admin.om.OMAdmin;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.upgrade.UpgradeException;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalization;
import picocli.CommandLine;

@CommandLine.Command(name="finalizeupgrade", description={"Finalizes Ozone Manager's metadata changes and enables new features after a software upgrade.\nIt is possible to specify the service ID for an HA environment, or the Ozone manager host in a non-HA environment, if none provided the default from configuration is being used if not ambiguous."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class FinalizeUpgradeSubCommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private OMAdmin parent;
    @CommandLine.Option(names={"-id", "--service-id"}, description={"Ozone Manager Service ID"})
    private String omServiceId;
    @CommandLine.Option(names={"-host", "--service-host"}, description={"Ozone Manager Host"})
    private String omHost;
    @CommandLine.Option(names={"--takeover"}, description={"Forces takeover of monitoring from an other client, if finalization has already been started and did not finished yet."})
    private boolean force;

    @Override
    public Void call() throws Exception {
        boolean forceHA = false;
        OzoneManagerProtocolClientSideTranslatorPB client = this.parent.createOmClient(this.omServiceId, this.omHost, forceHA);
        String upgradeClientID = "Upgrade-Client-" + UUID.randomUUID().toString();
        try {
            UpgradeFinalization.StatusAndMessages finalizationResponse = client.finalizeUpgrade(upgradeClientID);
            if (UpgradeFinalization.isFinalized((UpgradeFinalization.Status)finalizationResponse.status())) {
                System.out.println("Upgrade has already been finalized.");
                UpgradeFinalization.emitExitMsg();
                return null;
            }
            if (!UpgradeFinalization.isStarting((UpgradeFinalization.Status)finalizationResponse.status())) {
                System.err.println("Invalid response from Ozone Manager.");
                System.err.println("Current finalization status is: " + finalizationResponse.status());
                throw new IOException("Exiting...");
            }
        }
        catch (UpgradeException e) {
            UpgradeFinalization.handleInvalidRequestAfterInitiatingFinalization((boolean)this.force, (UpgradeException)e);
        }
        this.monitorAndWaitFinalization((OzoneManagerProtocol)client, upgradeClientID);
        return null;
    }

    private void monitorAndWaitFinalization(OzoneManagerProtocol client, String upgradeClientID) throws ExecutionException {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<Void> monitor = exec.submit(new UpgradeMonitor(client, upgradeClientID, this.force));
        try {
            monitor.get();
            UpgradeFinalization.emitFinishedMsg((String)"Ozone Manager");
        }
        catch (CancellationException e) {
            UpgradeFinalization.emitCancellationMsg((String)"Ozone Manager");
        }
        catch (InterruptedException e) {
            UpgradeFinalization.emitCancellationMsg((String)"Ozone Manager");
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            UpgradeFinalization.emitGeneralErrorMsg();
            throw e;
        }
        finally {
            exec.shutdown();
        }
    }

    private static class UpgradeMonitor
    implements Callable<Void> {
        private OzoneManagerProtocol client;
        private String upgradeClientID;
        private boolean force;

        UpgradeMonitor(OzoneManagerProtocol client, String upgradeClientID, boolean force) {
            this.client = client;
            this.upgradeClientID = upgradeClientID;
            this.force = force;
        }

        @Override
        public Void call() throws Exception {
            boolean finished = false;
            while (!finished) {
                UpgradeFinalization.StatusAndMessages progress;
                block6: {
                    block5: {
                        Thread.sleep(500L);
                        progress = this.client.queryUpgradeFinalizationProgress(this.upgradeClientID, this.force, false);
                        if (UpgradeFinalization.isFinalized((UpgradeFinalization.Status)progress.status())) {
                            System.out.println("Finalization already finished.");
                            UpgradeFinalization.emitExitMsg();
                            return null;
                        }
                        if (UpgradeFinalization.isInprogress((UpgradeFinalization.Status)progress.status())) break block5;
                        if (!UpgradeFinalization.isDone((UpgradeFinalization.Status)progress.status())) break block6;
                    }
                    progress.msgs().stream().forEachOrdered(System.out::println);
                }
                if (!UpgradeFinalization.isDone((UpgradeFinalization.Status)progress.status())) continue;
                UpgradeFinalization.emitExitMsg();
                finished = true;
            }
            return null;
        }
    }
}

