/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.datanode;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.cli.datanode.BasicDatanodeInfo;
import org.apache.hadoop.hdds.scm.cli.datanode.NodeSelectionMixin;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.ozone.shell.ListLimitOptions;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List info of datanodes"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ListInfoSubcommand
extends ScmSubcommand {
    @CommandLine.Option(names={"--operational-state"}, description={"Show info by datanode NodeOperationalState(IN_SERVICE, DECOMMISSIONING, DECOMMISSIONED, ENTERING_MAINTENANCE, IN_MAINTENANCE)."}, defaultValue="")
    private String nodeOperationalState;
    @CommandLine.Option(names={"--node-state"}, description={"Show info by datanode NodeState( HEALTHY, STALE, DEAD)"}, defaultValue="")
    private String nodeState;
    @CommandLine.Option(names={"--json"}, description={"Show info in json format"}, defaultValue="false")
    private boolean json;
    @CommandLine.ArgGroup(exclusive=true, multiplicity="0..1")
    private ExclusiveNodeOptions exclusiveNodeOptions;
    @CommandLine.Mixin
    private ListLimitOptions listLimitOptions;
    private List<Pipeline> pipelines;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        this.pipelines = scmClient.listPipelines();
        if (this.exclusiveNodeOptions != null && !Strings.isNullOrEmpty((String)this.exclusiveNodeOptions.getNodeId())) {
            HddsProtos.Node node = scmClient.queryNode(UUID.fromString(this.exclusiveNodeOptions.getNodeId()));
            BasicDatanodeInfo singleNodeInfo = new BasicDatanodeInfo(DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)node.getNodeID()), node.getNodeOperationalStates(0), node.getNodeStates(0));
            if (this.json) {
                List<BasicDatanodeInfo> dtoList = Collections.singletonList(singleNodeInfo);
                System.out.println(JsonUtils.toJsonStringWithDefaultPrettyPrinter(dtoList));
            } else {
                this.printDatanodeInfo(singleNodeInfo);
            }
            return;
        }
        Stream<Object> allNodes = this.getAllNodes(scmClient).stream();
        if (this.exclusiveNodeOptions != null && !Strings.isNullOrEmpty((String)this.exclusiveNodeOptions.getIp())) {
            allNodes = allNodes.filter(p -> p.getIpAddress().compareToIgnoreCase(this.exclusiveNodeOptions.getIp()) == 0);
        }
        if (this.exclusiveNodeOptions != null && !Strings.isNullOrEmpty((String)this.exclusiveNodeOptions.getHostname())) {
            allNodes = allNodes.filter(p -> p.getHostName().compareToIgnoreCase(this.exclusiveNodeOptions.getHostname()) == 0);
        }
        if (!Strings.isNullOrEmpty((String)this.nodeOperationalState)) {
            allNodes = allNodes.filter(p -> p.getOpState().toString().compareToIgnoreCase(this.nodeOperationalState) == 0);
        }
        if (!Strings.isNullOrEmpty((String)this.nodeState)) {
            allNodes = allNodes.filter(p -> p.getHealthState().toString().compareToIgnoreCase(this.nodeState) == 0);
        }
        if (!this.listLimitOptions.isAll()) {
            allNodes = allNodes.limit(this.listLimitOptions.getLimit());
        }
        if (this.json) {
            List datanodeList = allNodes.collect(Collectors.toList());
            System.out.println(JsonUtils.toJsonStringWithDefaultPrettyPrinter(datanodeList));
        } else {
            allNodes.forEach(this::printDatanodeInfo);
        }
    }

    private List<BasicDatanodeInfo> getAllNodes(ScmClient scmClient) throws IOException {
        if (this.exclusiveNodeOptions != null && (this.exclusiveNodeOptions.mostUsed || this.exclusiveNodeOptions.leastUsed)) {
            List usageInfos;
            boolean sortByMostUsed = this.exclusiveNodeOptions.mostUsed;
            try {
                usageInfos = scmClient.getDatanodeUsageInfo(sortByMostUsed, Integer.MAX_VALUE);
            }
            catch (Exception e) {
                System.err.println("Failed to get datanode usage info: " + e.getMessage());
                return Collections.emptyList();
            }
            return usageInfos.stream().map(p -> {
                try {
                    String uuidStr = p.getNode().getUuid();
                    UUID parsedUuid = UUID.fromString(uuidStr);
                    HddsProtos.Node node = scmClient.queryNode(parsedUuid);
                    long capacity = p.getCapacity();
                    long used = capacity - p.getRemaining();
                    double percentUsed = capacity > 0L ? (double)used * 100.0 / (double)capacity : 0.0;
                    return new BasicDatanodeInfo(DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)node.getNodeID()), node.getNodeOperationalStates(0), node.getNodeStates(0), used, capacity, percentUsed);
                }
                catch (Exception e) {
                    String reason = "Could not process info for an unknown datanode";
                    if (p != null && p.getNode() != null && !Strings.isNullOrEmpty((String)p.getNode().getUuid())) {
                        reason = "Could not process node info for " + p.getNode().getUuid();
                    }
                    System.err.printf("Error: %s: %s%n", reason, e.getMessage());
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        List nodes = scmClient.queryNode(null, null, HddsProtos.QueryScope.CLUSTER, "");
        return nodes.stream().map(p -> new BasicDatanodeInfo(DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)p.getNodeID()), p.getNodeOperationalStates(0), p.getNodeStates(0))).sorted(Comparator.comparing(BasicDatanodeInfo::getHealthState)).collect(Collectors.toList());
    }

    private void printDatanodeInfo(BasicDatanodeInfo dn) {
        StringBuilder pipelineListInfo = new StringBuilder();
        DatanodeDetails datanode = dn.getDatanodeDetails();
        int relatedPipelineNum = 0;
        if (!this.pipelines.isEmpty()) {
            List<Pipeline> relatedPipelines = this.pipelines.stream().filter(p -> p.getNodes().contains(datanode)).collect(Collectors.toList());
            if (relatedPipelines.isEmpty()) {
                pipelineListInfo.append("No related pipelines or the node is not in Healthy state.\n");
            } else {
                relatedPipelineNum = relatedPipelines.size();
                relatedPipelines.forEach(p -> pipelineListInfo.append(p.getId().getId().toString()).append('/').append(p.getReplicationConfig().toString()).append('/').append(p.getType().toString()).append('/').append(p.getPipelineState().toString()).append('/').append(datanode.getID().equals((Object)p.getLeaderId()) ? "Leader" : "Follower").append(System.getProperty("line.separator")));
            }
        } else {
            pipelineListInfo.append("No pipelines in cluster.");
        }
        System.out.println("Datanode: " + datanode.getUuid().toString() + " (" + datanode.getNetworkLocation() + "/" + datanode.getIpAddress() + "/" + datanode.getHostName() + "/" + relatedPipelineNum + " pipelines)");
        System.out.println("Operational State: " + dn.getOpState());
        System.out.println("Health State: " + dn.getHealthState());
        System.out.println("Related pipelines:\n" + pipelineListInfo);
        if (dn.getUsed() != null && dn.getCapacity() != null && dn.getUsed() >= 0L && dn.getCapacity() > 0L) {
            System.out.println("Capacity: " + dn.getCapacity());
            System.out.println("Used: " + dn.getUsed());
            System.out.printf("Percentage Used : %.2f%%%n%n", dn.getPercentUsed());
        }
    }

    static class ExclusiveNodeOptions
    extends NodeSelectionMixin {
        @CommandLine.Option(names={"--most-used"}, description={"Show datanodes sorted by Utilization (most to least)."})
        private boolean mostUsed;
        @CommandLine.Option(names={"--least-used"}, description={"Show datanodes sorted by Utilization (least to most)."})
        private boolean leastUsed;

        ExclusiveNodeOptions() {
        }
    }
}

